/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2014, Arnaud Roques
 *
 * Project Info:  http://plantuml.sourceforge.net
 * 
 * This file is part of PlantUML.
 *
 * Licensed under The MIT License (Massachusetts Institute of Technology License)
 * 
 * See http://opensource.org/licenses/MIT
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.preproc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class ReadLineReader implements ReadLine {

	private final BufferedReader br;

	public ReadLineReader(Reader reader) {
		br = new BufferedReader(reader);
	}

	public String readLine() throws IOException {
		String s = br.readLine();
		if (s != null && s.startsWith("\uFEFF")) {
			s = s.substring(1);
		}
		if (s != null) {
			s = s.replace('\u2013', '-');
			// s = s.replace('\u00A0', ' ');
			// s = s.replace('\u201c', '\"');
			// s = s.replace('\u201d', '\"');
			// s = s.replace('\u00ab', '\"');
			// s = s.replace('\u00bb', '\"');
			// s = s.replace('\u2018', '\'');
			// s = s.replace('\u2019', '\'');
			// for (int i = 0; i < s.length(); i++) {
			// char c = s.charAt(i);
			// System.err.println("X " + Integer.toHexString((int) c) + " " + c);
			// }
		}
		return s;
	}

	public void close() throws IOException {
		br.close();
	}

}
