/*
    Implementation of the kdebug applet for Plasma.
    Copyright (C) 2007 Tim Beaulen <tbscope@gmail.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "kdebugapplet.h"
#include <QPainter>
#include <QApplication>
#include <QFontMetrics>
#include <stdio.h>

KDebugApplet::KDebugApplet(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args)
{
    setDrawStandardBackground(true);

    m_timer = new QTimer(this);
    connect(m_timer, SIGNAL(timeout()), this, SLOT(timerUpdate()));
   
    m_kdebugInterface = new KDebugInterface(QString(), QString(), QDBusConnection::sessionBus(), this);
    connect(m_kdebugInterface, SIGNAL(message(QString)), this, SLOT(newMessage(QString)));

    m_timer->start(1000);

    constraintsUpdated();
}

KDebugApplet::~KDebugApplet()
{
}

QSizeF KDebugApplet::contentSizeHint() const
{
    return m_sizeHint;
}

void KDebugApplet::constraintsUpdated()
{
    prepareGeometryChange();
    m_sizeHint = QSizeF(600,300);
    update();
}

void KDebugApplet::paintInterface(QPainter *painter, const QStyleOptionGraphicsItem *option, const QRect &contentsRect)
{
    Q_UNUSED(option)

    painter->setPen(QPen(Qt::white));
    QFontMetrics fm(QApplication::font());
    painter->drawText(contentsRect, Qt::AlignLeft, m_connectTxt);

    QRect r = contentsRect;
    int y = 30 + contentsRect.top();

    r.setTop(y);

    foreach(QString msg, m_messages) {
        painter->drawText(r, Qt::AlignLeft, msg);
        y += fm.xHeight() + 8;
        r.setTop(y);
    }
}

void KDebugApplet::timerUpdate()
{
    if (m_kdebugInterface->isValid())
        m_connectTxt = "Connected to org.kde.KDebug";
    else
        m_connectTxt = "No org.kde.KDebug interface found!";

    update();
}

void KDebugApplet::newMessage(const QString& message)
{
    m_messages << message;
    if(m_messages.count() > 20)
        m_messages.removeFirst();
}

#include "kdebugapplet.moc"

