/*
 *     Copyright (C) 2007 the ktimetracker developers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the
 *      Free Software Foundation, Inc.
 *      51 Franklin Street, Fifth Floor
 *      Boston, MA  02110-1301  USA.
 *
 */

#include "ktimetrackerapplet.h"

#include <KAction>

#include <KDialog>
#include <KIcon>
#include <KLocale>
#include <KMessageBox>
#include <KRun>
#include <KUrl>

#include <plasma/svg.h>
#include <plasma/widgets/lineedit.h>
#include <plasma/widgets/icon.h>
#include <plasma/widgets/vboxlayout.h>

KTimetrackerApplet::KTimetrackerApplet(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args), mDialog( 0 )
{
  setHasConfigurationInterface( true );
  setDrawStandardBackground( true );

  mPixelSize = 120;

  //mLabel = new Plasma::LineEdit( this );
  //mLabel->setDefaultText( "ktimetracker is not started." );
  //mLabel->setTextInteractionFlags( Qt::NoTextInteraction );

  Plasma::VBoxLayout* layout = new Plasma::VBoxLayout( this );
  //layout->addItem( mLabel );

  mEngine = dataEngine( "ktimetracker" );
  mEngine->connectSource( "timetracker", this );
  updated( "timetracker", mEngine->query( "timetracker" ) );
  constraintsUpdated();

  mIcon = new Plasma::Icon( "My Task", this );
  mIcon->setIcon( KIcon( "karm" ) );
  layout->addItem( mIcon );

  KAction *startAction = new KAction( this );
  connect( startAction, SIGNAL( triggered( bool ) ),
           this, SLOT( startApplication() ) );
  mIcon->addAction( startAction );
}

QSizeF KTimetrackerApplet::contentSizeHint() const
{
  return QSizeF( 140, 160 );
}

void KTimetrackerApplet::showConfigurationInterface()
{
  if (mDialog == 0) {
    mDialog = new KDialog;
    mConfigWidget.setupUi( mDialog->mainWidget() );

    connect( mDialog, SIGNAL( applyClicked() ), 
             this, SLOT( configAccepted() ) );
    connect( mDialog, SIGNAL( okClicked() ), this, SLOT( configAccepted() ) );
  }

  mConfigWidget.taskName->clear();
  mConfigWidget.taskName->addItems(
    mEngine->query( "timetracker" )["tasks"].toStringList()
  );

  mDialog->show();
}

void KTimetrackerApplet::configAccepted()
{
  mIcon->setText( mConfigWidget.taskName->currentText() );
}

void KTimetrackerApplet::updated(const QString& source, const Plasma::DataEngine::Data &data)
{
  Q_UNUSED(source);
  bool started = data["ktimetracker-running"].toBool();
  if ( started ) {
    //mLabel->setDefaultText( "ktimetracker is started." );
  } else {
    //mLabel->setDefaultText( "ktimetracker is not started." );
  }
  update();
}

void KTimetrackerApplet::startApplication()
{
  KMessageBox::information( 0, i18n("Hello") );
  KRun::run( "ktimetracker", KUrl::List(), 0 );
}

KTimetrackerApplet::~KTimetrackerApplet()
{
}

#include "ktimetrackerapplet.moc"
