
/* Copyright 2009  Jan Gerrit Marker <jangerrit@weiler-marker.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//Project-Includes
#include "amarokrunner_config.h"
//Qt-Includes
#include <QtGui>
//KDE-Includes
#include <plasma/abstractrunner.h>

K_EXPORT_RUNNER_CONFIG(amarokrunner, AmarokRunnerConfig)

AmarokRunnerConfigForm::AmarokRunnerConfigForm(QWidget* parent) : QWidget(parent)
{
    setupUi(this);
}

AmarokRunnerConfig::AmarokRunnerConfig(QWidget* parent, const QVariantList& args) :
        KCModule(ConfigFactory::componentData(), parent, args)
{
    //GUI-Setup
    m_ui = new AmarokRunnerConfigForm(this);

    QGridLayout* layout = new QGridLayout(this);
    layout->addWidget(m_ui, 0, 0);

    connect(m_ui->sensitivity, SIGNAL(stateChanged(int)), this, SLOT(changed()));
    connect(m_ui->prefixuse, SIGNAL(stateChanged(int)), this, SLOT(changed()));
    connect(m_ui->searchPlaylist, SIGNAL(stateChanged(int)), this, SLOT(changed()));
    connect(m_ui->prefix_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->play_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->pause_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->next_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->mute_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->up_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->up_value, SIGNAL(valueChanged(int)), this, SLOT(changed()));
    connect(m_ui->down_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->down_value, SIGNAL(valueChanged(int)), this, SLOT(changed()));
    connect(m_ui->prev_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->stop_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->volume_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    connect(m_ui->quit_edit, SIGNAL(textChanged(const QString)), this, SLOT(changed()));
    //GUI-Setup FINISH

    load();
}

void AmarokRunnerConfig::load()
{
    KCModule::load();

    KSharedConfig::Ptr cfg = KSharedConfig::openConfig("krunnerrc");
    KConfigGroup grp = KConfigGroup(&cfg->group("Runners"), "Amarok Runner");
    m_ui->sensitivity->setChecked(((int) Qt::CaseSensitive) == grp.readEntry("val_caseSens" , false));
    m_ui->prefixuse->setChecked(grp.readEntry("prefixuse", true));
    m_ui->searchPlaylist->setChecked(grp.readEntry("searchPlaylist", true));
    m_ui->prefix_edit->setText(grp.readEntry("prefix", i18n("Amarok")));
    m_ui->play_edit->setText(grp.readEntry("com_play" , i18n("Play")));
    m_ui->pause_edit->setText(grp.readEntry("com_pause", i18n("Pause")));
    m_ui->next_edit->setText(grp.readEntry("com_next" , i18nc("next song", "Next")));
    m_ui->mute_edit->setText(grp.readEntry("com_mute" , i18n("Mute")));
    m_ui->up_edit->setText(grp.readEntry("com_up" , i18nc("incrase the sound volume", "Up")));
    m_ui->up_value->setValue(grp.readEntry("val_up" , 15));
    m_ui->down_edit->setText(grp.readEntry("com_down" , i18nc("reduce the sound volume", "Down")));
    m_ui->down_value->setValue(grp.readEntry("val_down" , 15));
    m_ui->prev_edit->setText(grp.readEntry("com_prev" , i18nc("previous song", "Prev")));
    m_ui->stop_edit->setText(grp.readEntry("com_stop" , i18n("Stop")));
    m_ui->volume_edit->setText(grp.readEntry("com_volume" , i18nc("set the sound volume to the volume after the '='", "Volume=")));
    m_ui->quit_edit->setText(grp.readEntry("com_quit", i18nc("quit Amarok", "Quit")));

    emit changed(false);
}

void AmarokRunnerConfig::save()
{
    KCModule::save();

    KSharedConfig::Ptr cfg = KSharedConfig::openConfig("krunnerrc");
    KConfigGroup grp = KConfigGroup(&cfg->group("Runners"), "Amarok Runner");
    grp.writeEntry("val_caseSens", ((m_ui->sensitivity->checkState() == Qt::Checked) ? (int) Qt::CaseSensitive : (int) Qt::CaseInsensitive));
    grp.writeEntry("prefixuse" , m_ui->prefixuse->checkState() == Qt::Checked);
    grp.writeEntry("searchPlaylist", m_ui->searchPlaylist->checkState() == Qt::Checked);
    grp.writeEntry("prefix", m_ui->prefix_edit->text());
    grp.writeEntry("com_play", m_ui->play_edit->text());
    grp.writeEntry("com_pause", m_ui->pause_edit->text());
    grp.writeEntry("com_stop", m_ui->stop_edit->text());
    grp.writeEntry("com_prev", m_ui->prev_edit->text());
    grp.writeEntry("com_next", m_ui->next_edit->text());
    grp.writeEntry("com_up", m_ui->up_edit->text());
    grp.writeEntry("val_up", m_ui->up_value->value());
    grp.writeEntry("com_down", m_ui->down_edit->text());
    grp.writeEntry("val_down", m_ui->down_value->value());
    grp.writeEntry("com_mute", m_ui->mute_edit->text());
    grp.writeEntry("com_volume", m_ui->volume_edit->text());
    grp.writeEntry("com_quit", m_ui->quit_edit->text());
    grp.sync();

    emit changed(false);
}

void AmarokRunnerConfig::defaults()
{
    KCModule::defaults();

    m_ui->sensitivity->setChecked(false);
    m_ui->prefixuse->setChecked(true);
    m_ui->searchPlaylist->setChecked(true);
    m_ui->prefix_edit->setText(i18n("Amarok"));
    m_ui->play_edit->setText(i18n("Play"));
    m_ui->pause_edit->setText(i18n("Pause")) ;
    m_ui->next_edit->setText(i18n("Next"));
    m_ui->mute_edit->setText(i18n("Mute"));
    m_ui->up_edit->setText(i18n("Up"));
    m_ui->up_value->setValue(15);
    m_ui->down_edit->setText(i18n("Down"));
    m_ui->down_value->setValue(15);
    m_ui->prev_edit->setText(i18n("Prev"));
    m_ui->stop_edit->setText(i18n("Stop"));
    m_ui->volume_edit->setText(i18n("Volume="));
    m_ui->quit_edit->setText(i18n("Quit"));

    emit changed(true);
}
