/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#ifndef FLICKR_OP_H
#define FLICKR_OP_H

#include <QPixmap>

#include <Plasma/Applet>
#include <Plasma/DataEngine>

#include "../engine/types.h"

class QCheckBox;
class QPushButton;
class QRadioButton;

class KColorButton;
class KComboBox;
class KConfigDialog;
class KFontRequester;
class KIntNumInput;
class KLineEdit;

class ClusterDialog;
class PhotosetDialog;

class FlickrOP : public Plasma::Applet
{
  Q_OBJECT
public:
  FlickrOP( QObject* p_parent, const QVariantList& p_args );
  ~FlickrOP();

protected:
  QList<QAction *> contextualActions();
  void createConfigurationInterface( KConfigDialog *p_parent );
  QWidget *createAuthenticationPage();
  QWidget *createGeneralPage();
  QWidget *createStreamsPage();
  void init();
  void paintInterface ( QPainter *p_painter, const QStyleOptionGraphicsItem *p_option, const QRect &p_contentsRect );
  void sendConfigurationToEngine();
  void setSize( const QString &p_size );

protected slots:
  void authenticate();
  void clusterChosen();
  void getClusters();
  void getPhotosets();
  void forceUpdate();
  void markAsFavorite();
  void photosetChosen();
  void photosetUserChanged( const QString &p_username );
  void photosetUserEdited( const QString &p_username );
  void radioChanged();
  void readConfig();
  void setOkButton();
  void showClusterDialog();
  void showErrorBox( const QString &p_message );
  void showPhotosetDialog();
  void tagTextChanged( const QString &p_tag );
  void tagTextEdited( const QString &p_tag );
  void visitAuthor();
  void visitAuthorPhotos();
  void visitPhoto();
  void writeConfig();

public slots:
  void dataUpdated( const QString &p_sourceName, const Plasma::DataEngine::Data &p_data );

private:
  // contains some data about the currently shown photo
  Photo m_photo;
  QString m_error;
  QPixmap m_pixmap;
  QList<QAction *> m_actions;
  Plasma::DataEngine *m_engine;
  bool m_authenticated;
  bool m_cluster_chosen;
  bool m_tag_edited;
  bool m_photoset_chosen;
  QString m_nsid;
  ClusterDialog *m_clusterdialog;
  PhotosetDialog *m_photosetdialog;

  // actions which require authorization
  QAction *m_markFavorite;

  // widgets
  KConfigDialog *m_config_dialog;
  KComboBox *m_interval_combo;
  KIntNumInput *m_interval_value;
  KComboBox *m_size_combo;
  QCheckBox *m_show_author_check;
  KFontRequester *m_author_font_req;
  KColorButton *m_colorbutton;
  QRadioButton *m_interesting_radio;
  QRadioButton *m_favorite_radio;
  QRadioButton *m_photoset_radio;
  QRadioButton *m_tag_radio;
  KLineEdit *m_tag_edit;
  KLineEdit *m_photoset_edit;
  QPushButton *m_get_cluster_button;
  QPushButton *m_get_photoset_button;

  // preferences
  Plasma::DataEngine::Data m_config;
  bool m_show_author;
  QFont m_author_font;
  QColor m_author_color;
  int m_font_height;
};

#endif // FLICKR_OP_H
