/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2008-2009 Giulio Camuffo		      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef FLOWLAYOUT_H
#define FLOWLAYOUT_H

#include <QtGui/QGraphicsLayout>

class QRectF;
class QGraphicsLayoutItem;

struct LayoutItem {
    QGraphicsLayoutItem *item;
    int row;
    int column;
};

class FlowLayout : public QGraphicsLayout
{
    public:
	FlowLayout(QGraphicsLayoutItem *parent);
	~FlowLayout();

	enum Orientation {
	    Horizontal,
	    Vertical
	};   

	void addItem(QGraphicsLayoutItem *item);
	int count() const;
	int rowCount() const;
	int columnCount() const;
	QGraphicsLayoutItem *itemAt(int index) const;
	void removeAt(int index);
	void removeItem(QGraphicsLayoutItem *item);
	void setGeometry(const QRectF &rect);
	void setOrientation(int orient);
	void setPrimarySpacing(int spacing);
	void setSecondarySpacing(int spacing);
	QSizeF sizeHint(Qt::SizeHint which, const QSizeF &constraint = QSizeF()) const;

    private:
	int doLayout(const QRectF &rect) const;
	LayoutItem *takeAt(int index);
	int indexAt(int row, int column) const;
	int columnsPerRow(int row) const;
	int rowsPerColumn(int column) const;

	QList<LayoutItem *> itemList;
	int orientation;
	int primarySpacing;
	int secondarySpacing;


};

 #endif