#include "languageform.h"
#include <KIcon>
#include <QFile>
#include <KGlobal>
#include <KDebug>
#include <QDialogButtonBox>
LanguageForm::LanguageForm(QWidget *parent) :
        QWidget(parent)

{
    m_ui = new Ui::LanguageForm;
    m_ui->setupUi(this);
    m_ui->kpushbuttonA->setObjectName("buttonA");
    m_ui->kpushbuttonB->setObjectName("buttonB");

    connect(m_ui->kpushbuttonA, SIGNAL(clicked()), this, SLOT(changeLanguage()));
    connect(m_ui->kpushbuttonB, SIGNAL(clicked()), this, SLOT(changeLanguage()));
}

LanguageForm::~LanguageForm()
{
//     delete m_ui;
}

void LanguageForm::changeLanguage()
{

    LanguageModel * model = new LanguageModel;
    QDialog * dialog = new QDialog;
    QDialogButtonBox * buttons = new QDialogButtonBox(QDialogButtonBox::Save);
    QTreeView * tree = new QTreeView(dialog);
    tree->setModel(model);
    QVBoxLayout * layout = new QVBoxLayout();
    layout->addWidget(tree);
    layout->addWidget(buttons);
    dialog->setLayout(layout);
    connect(buttons, SIGNAL(accepted()), dialog, SLOT(accept()));
    dialog->exec();


    KPushButton * button = qobject_cast<KPushButton *>(sender());
//
    QModelIndex index= model->index(tree->currentIndex().row(),0 );

    button->setText(model->getCode(index));
    button->setIcon(KIcon(model->getIcon(index)));

//
    if (button->objectName() == QString("buttonA"))
        m_a = model->getLanguage(index);
//
    if (button->objectName() == QString("buttonB"))
        m_b = model->getLanguage(index);



}

void LanguageForm::setLanguage(Language a, Language b)
{

    m_ui->kpushbuttonA->setIcon(KIcon(a.icon));
    m_ui->kpushbuttonA->setText(a.name);
    m_ui->kpushbuttonB->setIcon(KIcon(b.icon));
    m_ui->kpushbuttonB->setText(b.name);

    m_a = a;
    m_b = b;

}