/*************************************************************************\
*   Copyright (C) 2009 by Ulf Kreissig                                    *
*   udev@gmx.net                                                          *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
\*************************************************************************/

#ifndef UTILS_H
#define UTILS_H

//--- LOCAL ---
#include "yawpdefines.h"

//--- QT4 ---
class QTime;

namespace Utils
{
	void ShowUrl( const QLatin1String & url );
	bool IsDayTime( const QTime & sunrise, const QTime & sunset );
	
	/*  Extract the country from the string sLocation and try to find the countrycode
	 *  for this country using UsStatesMap and CountryMap.
	 *  We expect a string like this >City, Country< or >City, Country(County)<
	 */
	bool GetCountryCode( const QString & sCountry, QString & sCountryCode );
	void ExtractLocationInfo( const QString & sLocation,
	                          QString & sCity,
	                          QString & sDistrict,
	                          QString & sCountry );

};

#endif // UTILS_H