/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *                             *									      *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef MMINFOWIDGET_H
#define MMINFOWIDGET_H


#include <QGraphicsWidget>
#include <QGraphicsProxyWidget>
#include <QGraphicsLinearLayout>

#include <Plasma/Applet>

#include "mmbuttonwidget.h"
#include "mminfodisplay.h"
#include "mminfodialog.h"
#include "mmprogressbar.h"

class MMInfoWidget : public QGraphicsWidget
{
Q_OBJECT

    public:
	MMInfoWidget(Plasma::Applet *parent);
	virtual ~MMInfoWidget(void);

	void setContentSize(int x, int y);
	void setContentSize(QSizeF size);
	void setIsOnPanel(bool value);
	void setCloseDialogOnFocusOut(bool value);
	void setDialogTextColor(QColor color);
	QColor getDialogTextColor(void) const;
	void setTextColor(QColor color);
	QColor getTextColor(void) const;
	void setScrollStrings(bool scrollStrings);
	void setShowStrings(bool showStrings);
	void setPlayer(int pl);

	bool getCloseDialogOnFocusOut(void) const;
	bool getScrollStrings(void) const;
	QSize getDialogSize(void) const;

	MMButtonWidget *controlWidgetObj(void);
	MMProgressBar *progressBarObj(void);

	void recalculateGeometry(void);

    public slots:
	void updateTitle(const QString &);
	void updateArtist(const QString &);
	void updateAlbum(const QString &);
	void updateTime(const QString &);
	void updateTrack(const QString &);
	void updateBar(const int &);
	void updateStatus(const QString &);

    private slots:
	void toggleDialogIsVisible(void);

    private:
	QSizeF contentSizeHint() const;

	MMButtonWidget *controlWidget;
	MMProgressBar *pbar;
	MMInfoDisplay *infos;
	MMInfoDialog *dialog;
	Plasma::Applet *parentApplet;
	QGraphicsProxyWidget *proxyInfos;
	QGraphicsLinearLayout *t_layout;
	int t_width;
	int t_height;
	int player;
	bool isOnPanel;
	bool showStrings;
	bool closeDialogOnFocusOut;
	bool isDialogCreated;
};

#endif
