/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *                             *									      *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/


#ifndef MMPROGRESSBAR_H
#define MMPROGRESSBAR_H


#include <QGraphicsSceneMouseEvent>
#include <QGraphicsProxyWidget>
#include <QProgressBar>

class MMProgressBar : public QGraphicsProxyWidget
{
    Q_OBJECT

    public:
        MMProgressBar(QGraphicsItem *parent);
        ~MMProgressBar(void);

	void setValue(int value);
	void setMaxHeight(double height);

        void mousePressEvent(QGraphicsSceneMouseEvent *event);

    signals:
        void valueChanged(const int &value);

    private:
	QProgressBar *bar;

};

#endif
