%module playertcp_java

%include "typemaps.i"
%include "arrays_java.i"

// Tell SWIG that an int* function argument should be treated as an array
// of ints
%apply int[ANY] {int*};

// Should not need these typemaps, but the ones generated by SWIG does not
// work
%typemap(in) int* {
  $1 = (int*)(jenv->GetIntArrayElements($input, 0));
}
%typemap(freearg) int* {
  jenv->ReleaseIntArrayElements($input, (jint*)$1, 0);
}
%typemap(argout) int* {
}

// The stuff between the braces gets copied verbatim into the output
%{
#include <libplayertcp/playertcp.h>
#include <libplayerxdr/functiontable.h>
%}

%include <libplayertcp/playertcp.h>
%include <libplayerxdr/functiontable.h>
