/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001  Kevin P. Lawton
 *
 *  stubs-r3.S: Assembly data + code stubs to call C handlers.
 *    The data component mirrors the C type 'r3hData_t'.  Make sure
 *    to keep it in sync.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#define OFFSET_OF(field)  [field - __r3hStubsDataStart]


.section  r3hSection,"ax",@progbits


/* Align start of asm data area on page boundary so we can map it
 * R/W by ring3 into the monitor.  Since this data page is modified,
 * a private page will be allocated for each VM, and mapped into
 * this space in the monitor.  So this page is merely a place-holder, and
 * useful for coding direct displacements in the code below.
 */
.globl __r3hNewEIP

.p2align 12
.globl __r3hStubsDataStart
__r3hStubsDataStart:

.globl __hashID
.globl __r3hESP
.globl __r3hSS
.globl __r3hRequest
.globl __r3hData
.globl __r3hTargetEIP
.globl __guestESP
.globl __guestSS
.globl __r3hBranchDataAddr
.globl __r3hAsyncEvent
.globl __dtG2THash

/* Data fields. */
__hashID:            ; .skip 4, 0
__r3hESP:            ; .skip 4, 0
__r3hSS:             ; .skip 4, 0
__r3hRequest:        ; .skip 4, 0
__r3hData:           ; .skip 4, 0
__r3hTargetEIP:      ; .skip 4, 0
__guestESP:          ; .skip 4, 0
__guestSS:           ; .skip 4, 0
__r3hBranchDataAddr: ; .skip 4, 0
__r3hAsyncEvent:     ; .skip 4, 0

/* Structure pointers. */
__dtG2THash:         ; .skip 4, 0



/* Align start of asm code area on page boundary so we can map it
 * read-only by ring3 into the monitor.
 */

.p2align 12
.globl __r3hStubsCodeStart
__r3hStubsCodeStart:

.globl __r3hBranchStatic
__r3hBranchStatic:
  gs; movl %esp, __guestESP
  gs; lss __r3hESP, %esp
  pushfl
  pushl %eax
  pushl %ecx
  gs; movl __r3hBranchDataAddr, %eax

  gs; testb $0x01, __r3hAsyncEvent
  jnz deferToAsyncEvent

  gs; movl __hashID, %ecx
  gs; cmpl 4(%eax), %ecx
  jne hashIDInvalid
  gs; movl 8(%eax), %ecx
  gs; movl %ecx, __r3hTargetEIP
done:
  popl  %ecx
  popl  %eax
  popfl
  gs; lss  __guestESP, %esp
  gs; jmp *(__r3hTargetEIP)

deferToAsyncEvent:
  /* If there are asynchronous events waiting, then we should defer
   * to the monitor to handle them, and not carry through with the
   * branch.
   */
  gs; movl $__r3hNewEIP, __r3hTargetEIP
  gs; movl (%eax), %ecx
  gs; movl %ecx, __r3hData
  jmp done

hashIDInvalid:
  pushl %edx
  pushl %ebx
  pushl %esp
  pushl %ebp
  pushl %esi
  pushl %edi

  pushl %ds                 /* Save guest DS/ES - handler needs to use them. */
  pushl %es                 /* and sets them to its own segment. */

  mov   %gs, %ax            /* Copy handler GS to {DS,ES}, for GCC/C-code. */
  mov   %ax, %ds
  mov   %ax, %es
  cld                       /* For GCC/C-code. */
  call r3hBranchStatic      /* Call C handler */
  popl %es                  /* Restore guest DS/ES segments. */
  popl %ds
  popal                     /* Restore guest general registers. */
  popfl                     /* Restore guest eflags. */
  gs; lss  __guestESP, %esp /* Restore guest stack. */
  gs; jmp *(__r3hTargetEIP)
  


/* The following routine is called when a branch takes EIP to a value
 * not in the hash tables.  Really, we just do an INT3, but from this
 * address tells the monitor what is being requested, and let's the
 * r3h code restore all guest state before jumping here, so the
 * monitor has flexibility on what to do next.
 */
__r3hNewEIP:
  .byte 0xcc /* INT 3 */
