/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  fpu.c: Floating Point oriented instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"



  void
FWAIT(vm_t *vm)
{
  if ( vm->guest_cpu.cr0.fields.ts && vm->guest_cpu.cr0.fields.mp ) {
    monpanic(vm, "FWAIT: generating #NM\n");
    exception(vm, ExceptionNM, 0);
    }

  monprint(vm, "(IGNORING) FWAIT:\n");
}

  void
ESC0(vm_t *vm)
{
  if ( vm->guest_cpu.cr0.fields.em || vm->guest_cpu.cr0.fields.ts ) {
    exception(vm, ExceptionNM, 0);
    }
  monprint(vm, "ESC0:\n");
}

  void
ESC1(vm_t *vm)
{
  if ( vm->guest_cpu.cr0.fields.em || vm->guest_cpu.cr0.fields.ts ) {
    exception(vm, ExceptionNM, 0);
    }
  monprint(vm, "ESC1:\n");
}

  void
ESC2(vm_t *vm)
{
  if ( vm->guest_cpu.cr0.fields.em || vm->guest_cpu.cr0.fields.ts ) {
    exception(vm, ExceptionNM, 0);
    }
  monprint(vm, "ESC2:\n");
}

  void
ESC3(vm_t *vm)
{
  if ( vm->guest_cpu.cr0.fields.em || vm->guest_cpu.cr0.fields.ts ) {
    exception(vm, ExceptionNM, 0);
    }
  monprint(vm, "ESC3:\n");
}

  void
ESC4(vm_t *vm)
{
  if ( vm->guest_cpu.cr0.fields.em || vm->guest_cpu.cr0.fields.ts ) {
    exception(vm, ExceptionNM, 0);
    }
  monprint(vm, "ESC4:\n");
}

  void
ESC5(vm_t *vm)
{
  if ( vm->guest_cpu.cr0.fields.em || vm->guest_cpu.cr0.fields.ts ) {
    exception(vm, ExceptionNM, 0);
    }
  monprint(vm, "ESC5:\n");
}

  void
ESC6(vm_t *vm)
{
  if ( vm->guest_cpu.cr0.fields.em || vm->guest_cpu.cr0.fields.ts ) {
    exception(vm, ExceptionNM, 0);
    }
  monprint(vm, "ESC6:\n");
}

  void
ESC7(vm_t *vm)
{
  if ( vm->guest_cpu.cr0.fields.em || vm->guest_cpu.cr0.fields.ts ) {
    exception(vm, ExceptionNM, 0);
    }
  monprint(vm, "ESC7:\n");
}
