/////////////////////////////////////////////////////////////////////////
// $Id: pic-mon.c,v 1.1.1.3 2002/07/20 18:31:45 DemonLord Exp $
/////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2002  MandrakeSoft S.A.
//
//    MandrakeSoft S.A.
//    43, rue d'Aboukir
//    75002 Paris - France
//    http://www.linux-mandrake.com/
//    http://www.mandrakesoft.com/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA


#include "plex86.h"
#define IN_MONITOR_SPACE
#include "monitor.h"




  Bit32u
picIORead(vm_t *vm, Bit32u address, unsigned io_len)
{
  if (io_len > 1) {
    monpanic(vm, "pic: io read from port %04x, len=%u\n", (unsigned) address,
             (unsigned) io_len);
    }

  if((address == 0x20 || address == 0x21) && vm->pic.s.master_pic.polled) {
    // In polled mode. Treat this as an interrupt acknowledge
    picClearHighestInterrupt(& vm->pic.s.master_pic);
    vm->pic.s.master_pic.polled = 0;
    picServiceMaster(vm);
    return vm->pic.s.master_pic.irq;  // Return the current irq requested
  }

  if((address == 0xa0 || address == 0xa1) && vm->pic.s.slave_pic.polled) {
    // In polled mode. Treat this as an interrupt acknowledge
    picClearHighestInterrupt(& vm->pic.s.slave_pic);
    vm->pic.s.slave_pic.polled = 0;
    picServiceSlave(vm);
    return vm->pic.s.slave_pic.irq;  // Return the current irq requested
  }

  switch (address) {
    case 0x20:
      if (vm->pic.s.master_pic.read_reg_select) { /* ISR */
        return(vm->pic.s.master_pic.isr);
        }
      else { /* IRR */
        return(vm->pic.s.master_pic.irr);
        }
      break;
    case 0x21:
      return(vm->pic.s.master_pic.imr);
      break;
    case 0xA0:
      if (vm->pic.s.slave_pic.read_reg_select) { /* ISR */
        return(vm->pic.s.slave_pic.isr);
        }
      else { /* IRR */
        return(vm->pic.s.slave_pic.irr);
        }
      break;
    case 0xA1:
      return(vm->pic.s.slave_pic.imr);
      break;
    }

  monpanic(vm, "pic: io read to address %04x\n", (unsigned) address);
}

  void
picIOWrite(vm_t *vm, Bit32u address, Bit32u value, unsigned io_len)
{
//int irq;

  if (io_len > 1) {
    monpanic(vm, "pic: io write to port %04x, len=%u\n", (unsigned) address,
             (unsigned) io_len);
    }

  switch (address) {
    case 0x20:
      if (value & 0x10) { /* initialization command 1 */
            // (mch) Ignore...
            // monprint(vm, "pic:master: init command 1 found %02x\n", (unsigned) value);
        vm->pic.s.master_pic.init.in_init = 1;
        vm->pic.s.master_pic.init.requires_4 = (value & 0x01);
        vm->pic.s.master_pic.init.byte_expected = 2; /* operation command 2 */
        vm->pic.s.master_pic.imr           = 0x00; /* clear the irq mask register */
        vm->pic.s.master_pic.isr           = 0x00; /* no IRQ's in service */
        vm->pic.s.master_pic.irr           = 0x00; /* no IRQ's requested */
        vm->pic.s.master_pic.lowest_priority = 7;
        vm->pic.s.master_pic.INT = 0; /* reprogramming clears previous INTR request */
        vm->pic.s.master_pic.auto_eoi = 0;
        vm->pic.s.master_pic.rotate_on_autoeoi = 0;
        if (value & 0x02) {
          monpanic(vm, "pic:master: ICW1: single mode not supported\n");
          }
        if (value & 0x08) {
          monpanic(vm, "pic:master: ICW1: level sensitive mode not supported\n");
          }
        setINTR(vm, 0);
        return;
        }

      if ( (value & 0x18) == 0x08 ) { /* OCW3 */
        Bit8u special_mask, poll, read_op;

        special_mask = (value & 0x60) >> 5;
        poll         = (value & 0x04) >> 2;
        read_op      = (value & 0x03);
        if (poll) {
          vm->pic.s.master_pic.polled = 1;
          return;
        }
        if (read_op == 0x02) /* read IRR */
          vm->pic.s.master_pic.read_reg_select = 0;
        else if (read_op == 0x03) /* read ISR */
          vm->pic.s.master_pic.read_reg_select = 1;
        if (special_mask == 0x02) { /* cancel special mask */
          vm->pic.s.master_pic.special_mask = 0;
          }
        else if (special_mask == 0x03) { /* set specific mask */
          vm->pic.s.master_pic.special_mask = 1;
          picServiceMaster(vm);
          }
        return;
        }

      /* OCW2 */
      switch (value) {
        case 0x00: // Rotate in auto eoi mode clear
        case 0x80: // Rotate in auto eoi mode set
          vm->pic.s.master_pic.rotate_on_autoeoi = (value != 0);
          break;
        case 0x0A: /* select read interrupt request register */
          vm->pic.s.master_pic.read_reg_select = 0;
          break;
        case 0x0B: /* select read interrupt in-service register */
          vm->pic.s.master_pic.read_reg_select = 1;
          break;

        case 0xA0: // Rotate on non-specific end of interrupt
        case 0x20: /* end of interrupt command */

          picClearHighestInterrupt(& vm->pic.s.master_pic);

          if(value == 0xA0) {// Rotate in Auto-EOI mode
            vm->pic.s.master_pic.lowest_priority ++;
            if(vm->pic.s.master_pic.lowest_priority > 7)
              vm->pic.s.master_pic.lowest_priority = 0;
          }

          picServiceMaster(vm);
          break;

        case 0x40: // Intel PIC spec-sheet seems to indicate this should be ignored
          monprint(vm, "IRQ no-op\n");
          break;

        case 0x60: /* specific EOI 0 */
        case 0x61: /* specific EOI 1 */
        case 0x62: /* specific EOI 2 */
        case 0x63: /* specific EOI 3 */
        case 0x64: /* specific EOI 4 */
        case 0x65: /* specific EOI 5 */
        case 0x66: /* specific EOI 6 */
        case 0x67: /* specific EOI 7 */
          vm->pic.s.master_pic.isr &= ~(1 << (value-0x60));
          picServiceMaster(vm);
          break;

        // IRQ lowest priority commands
        case 0xC0: // 0 7 6 5 4 3 2 1
        case 0xC1: // 1 0 7 6 5 4 3 2
        case 0xC2: // 2 1 0 7 6 5 4 3
        case 0xC3: // 3 2 1 0 7 6 5 4
        case 0xC4: // 4 3 2 1 0 7 6 5
        case 0xC5: // 5 4 3 2 1 0 7 6
        case 0xC6: // 6 5 4 3 2 1 0 7
        case 0xC7: // 7 6 5 4 3 2 1 0
          monprint(vm, "pic: IRQ lowest command 0x%x\n", value);
          vm->pic.s.master_pic.lowest_priority = value - 0xC0;
          break;

        case 0xE0: // specific EOI and rotate 0
        case 0xE1: // specific EOI and rotate 1
        case 0xE2: // specific EOI and rotate 2
        case 0xE3: // specific EOI and rotate 3
        case 0xE4: // specific EOI and rotate 4
        case 0xE5: // specific EOI and rotate 5
        case 0xE6: // specific EOI and rotate 6
        case 0xE7: // specific EOI and rotate 7
          vm->pic.s.master_pic.isr &= ~(1 << (value-0xE0));
          vm->pic.s.master_pic.lowest_priority = (value - 0xE0);
          picServiceMaster(vm);

          break;

        default:
          monpanic(vm, "PIC: write to port 20h = %02x\n", value);
        } /* switch (value) */
      break;

    case 0x21:
      /* initialization mode operation */
      if (vm->pic.s.master_pic.init.in_init) {
        switch (vm->pic.s.master_pic.init.byte_expected) {
          case 2:
            vm->pic.s.master_pic.interrupt_offset = value & 0xf8;
            vm->pic.s.master_pic.init.byte_expected = 3;
            return;
            break;
          case 3:
            if (vm->pic.s.master_pic.init.requires_4) {
              vm->pic.s.master_pic.init.byte_expected = 4;
              }
            else {
              vm->pic.s.master_pic.init.in_init = 0;
              }
            return;
            break;
          case 4:
            if (value & 0x02) {
              vm->pic.s.master_pic.auto_eoi = 1;
              }
            else {
              vm->pic.s.master_pic.auto_eoi = 0;
              }
            if (value & 0x01) {
              }
            else
              monpanic(vm, "pic:        not 80x86 mode\n");
            vm->pic.s.master_pic.init.in_init = 0;
            return;
            break;
          default:
            monpanic(vm, "pic:master expecting bad init command\n");
          }
        }

      /* normal operation */
      vm->pic.s.master_pic.imr = value;
      picServiceMaster(vm);
      return;
      break;

    case 0xA0:
      if (value & 0x10) { /* initialization command 1 */
        vm->pic.s.slave_pic.init.in_init = 1;
        vm->pic.s.slave_pic.init.requires_4 = (value & 0x01);
        vm->pic.s.slave_pic.init.byte_expected = 2; /* operation command 2 */
        vm->pic.s.slave_pic.imr           = 0x00; /* clear irq mask */
        vm->pic.s.slave_pic.isr           = 0x00; /* no IRQ's in service */
        vm->pic.s.slave_pic.irr           = 0x00; /* no IRQ's requested */
        vm->pic.s.slave_pic.lowest_priority = 7;
        vm->pic.s.slave_pic.INT = 0; /* reprogramming clears previous INTR request */
        vm->pic.s.slave_pic.auto_eoi = 0;
        vm->pic.s.slave_pic.rotate_on_autoeoi = 0;
        if (value & 0x02) {
          monpanic(vm, "pic:slave: ICW1: single mode not supported\n");
          }
        if (value & 0x08) {
          monpanic(vm, "pic:slave: ICW1: level sensitive mode not supported\n");
          }
        return;
        }

      if ( (value & 0x18) == 0x08 ) { /* OCW3 */
        Bit8u special_mask, poll, read_op;

        special_mask = (value & 0x60) >> 5;
        poll         = (value & 0x04) >> 2;
        read_op      = (value & 0x03);
        if (poll) {
          vm->pic.s.master_pic.polled = 1;
          return;
        }
        if (read_op == 0x02) /* read IRR */
          vm->pic.s.slave_pic.read_reg_select = 0;
        else if (read_op == 0x03) /* read ISR */
          vm->pic.s.slave_pic.read_reg_select = 1;
        if (special_mask == 0x02) { /* cancel special mask */
          vm->pic.s.slave_pic.special_mask = 0;
          }
        else if (special_mask == 0x03) { /* set specific mask */
          vm->pic.s.slave_pic.special_mask = 1;
          picServiceSlave(vm);
          }
        return;
        }

      switch (value) {
        case 0x00: // Rotate in auto eoi mode clear
        case 0x80: // Rotate in auto eoi mode set
          vm->pic.s.slave_pic.rotate_on_autoeoi = (value != 0);
          break;
        case 0x0A: /* select read interrupt request register */
          vm->pic.s.slave_pic.read_reg_select = 0;
          break;
        case 0x0B: /* select read interrupt in-service register */
          vm->pic.s.slave_pic.read_reg_select = 1;
          break;
        case 0xA0: // Rotate on non-specific end of interrupt
        case 0x20: /* end of interrupt command */

          picClearHighestInterrupt(& vm->pic.s.slave_pic);

          if(value == 0xA0) {// Rotate in Auto-EOI mode
            vm->pic.s.slave_pic.lowest_priority ++;
            if(vm->pic.s.slave_pic.lowest_priority > 7)
              vm->pic.s.slave_pic.lowest_priority = 0;
          }

          picServiceSlave(vm);
          break;

        case 0x40: // Intel PIC spec-sheet seems to indicate this should be ignored
          monprint(vm, "IRQ no-op\n");
          break;

        case 0x60: /* specific EOI 0 */
        case 0x61: /* specific EOI 1 */
        case 0x62: /* specific EOI 2 */
        case 0x63: /* specific EOI 3 */
        case 0x64: /* specific EOI 4 */
        case 0x65: /* specific EOI 5 */
        case 0x66: /* specific EOI 6 */
        case 0x67: /* specific EOI 7 */
          vm->pic.s.slave_pic.isr &= ~(1 << (value-0x60));
          picServiceSlave(vm);
          break;

        // IRQ lowest priority commands
        case 0xC0: // 0 7 6 5 4 3 2 1
        case 0xC1: // 1 0 7 6 5 4 3 2
        case 0xC2: // 2 1 0 7 6 5 4 3
        case 0xC3: // 3 2 1 0 7 6 5 4
        case 0xC4: // 4 3 2 1 0 7 6 5
        case 0xC5: // 5 4 3 2 1 0 7 6
        case 0xC6: // 6 5 4 3 2 1 0 7
        case 0xC7: // 7 6 5 4 3 2 1 0
          monprint(vm, "pic: IRQ lowest command 0x%x\n", value);
          vm->pic.s.slave_pic.lowest_priority = value - 0xC0;
          break;

        case 0xE0: // specific EOI and rotate 0
        case 0xE1: // specific EOI and rotate 1
        case 0xE2: // specific EOI and rotate 2
        case 0xE3: // specific EOI and rotate 3
        case 0xE4: // specific EOI and rotate 4
        case 0xE5: // specific EOI and rotate 5
        case 0xE6: // specific EOI and rotate 6
        case 0xE7: // specific EOI and rotate 7
          vm->pic.s.slave_pic.isr &= ~(1 << (value-0xE0));
          vm->pic.s.slave_pic.lowest_priority = (value - 0xE0);
          picServiceSlave(vm);

          break;

        default:
          monpanic(vm, "PIC: write to port A0h = %02x\n", value);
        } /* switch (value) */
      break;

    case 0xA1:
      /* initialization mode operation */
      if (vm->pic.s.slave_pic.init.in_init) {
        switch (vm->pic.s.slave_pic.init.byte_expected) {
          case 2:
            vm->pic.s.slave_pic.interrupt_offset = value & 0xf8;
            vm->pic.s.slave_pic.init.byte_expected = 3;
            return;
            break;
          case 3:
            if (vm->pic.s.slave_pic.init.requires_4) {
              vm->pic.s.slave_pic.init.byte_expected = 4;
              }
            else {
              vm->pic.s.slave_pic.init.in_init = 0;
              }
            return;
            break;
          case 4:
            if (value & 0x02) {
              vm->pic.s.slave_pic.auto_eoi = 1;
              }
            else {
              vm->pic.s.slave_pic.auto_eoi = 0;
              }
            if (value & 0x01) {
              }
            else
              monpanic(vm, "pic: not 80x86 mode\n");
            vm->pic.s.slave_pic.init.in_init = 0;
            return;
            break;
          default:
            monpanic(vm, "pic:slave: expecting bad init command\n");
          }
        }

      /* normal operation */
      vm->pic.s.slave_pic.imr = value;
      picServiceSlave(vm);
      return;
      break;
    } /* switch (address) */

  return;
}
