/////////////////////////////////////////////////////////////////////////
// $Id: pic-nexus.c,v 1.2 2002/08/12 18:43:18 DemonLord Exp $
/////////////////////////////////////////////////////////////////////////
//
//  Copyright (C) 2002  MandrakeSoft S.A.
//
//    MandrakeSoft S.A.
//    43, rue d'Aboukir
//    75002 Paris - France
//    http://www.linux-mandrake.com/
//    http://www.mandrakesoft.com/
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA


#include "plex86.h"
#define IN_NEXUS_SPACE
#include "monitor.h"



  void
picInit(vm_t *vm)
{
  mon_memzero(&vm->pic, sizeof(vm->pic));

  registerIORHandler(vm, MonitorSpace, 0, picIORead, 0x0020, 1, "8259 PIC");
  registerIORHandler(vm, MonitorSpace, 0, picIORead, 0x0021, 1, "8259 PIC");
  registerIORHandler(vm, MonitorSpace, 0, picIORead, 0x00A0, 1, "8259 PIC");
  registerIORHandler(vm, MonitorSpace, 0, picIORead, 0x00A1, 1, "8259 PIC");

  registerIOWHandler(vm, MonitorSpace, 0, picIOWrite, 0x0020, 1, "8259 PIC");
  registerIOWHandler(vm, MonitorSpace, 0, picIOWrite, 0x0021, 1, "8259 PIC");
  registerIOWHandler(vm, MonitorSpace, 0, picIOWrite, 0x00A0, 1, "8259 PIC");
  registerIOWHandler(vm, MonitorSpace, 0, picIOWrite, 0x00A1, 1, "8259 PIC");


  vm->pic.s.master_pic.single_PIC = 0;
  vm->pic.s.master_pic.interrupt_offset = 0x08; /* IRQ0 = INT 0x08 */
  /* slave PIC connected to IRQ2 of master */
  vm->pic.s.master_pic.u.slave_connect_mask = 0x04;
  vm->pic.s.master_pic.sfnm = 0; /* normal nested mode */
  vm->pic.s.master_pic.buffered_mode = 0; /* unbuffered mode */
  vm->pic.s.master_pic.master_slave  = 0; /* no meaning, buffered_mode=0 */
  vm->pic.s.master_pic.auto_eoi      = 0; /* manual EOI from CPU */
  vm->pic.s.master_pic.imr           = 0xFF; /* all IRQ's initially masked */
  vm->pic.s.master_pic.isr           = 0x00; /* no IRQ's in service */
  vm->pic.s.master_pic.irr           = 0x00; /* no IRQ's requested */
  vm->pic.s.master_pic.read_reg_select = 0; /* IRR */
  vm->pic.s.master_pic.irq = 0;
  vm->pic.s.master_pic.INT = 0;
  vm->pic.s.master_pic.init.in_init = 0;
  vm->pic.s.master_pic.init.requires_4 = 0;
  vm->pic.s.master_pic.init.byte_expected = 0;
  vm->pic.s.master_pic.special_mask = 0;
  vm->pic.s.master_pic.lowest_priority = 7;
  vm->pic.s.master_pic.polled = 0;
  vm->pic.s.master_pic.rotate_on_autoeoi = 0;

  vm->pic.s.slave_pic.single_PIC = 0;
  vm->pic.s.slave_pic.interrupt_offset = 0x70; /* IRQ8 = INT 0x70 */
  vm->pic.s.slave_pic.u.slave_id = 0x02; /* slave PIC connected to IRQ2 of master */
  vm->pic.s.slave_pic.sfnm       = 0; /* normal nested mode */
  vm->pic.s.slave_pic.buffered_mode = 0; /* unbuffered mode */
  vm->pic.s.slave_pic.master_slave  = 0; /* no meaning, buffered_mode=0 */
  vm->pic.s.slave_pic.auto_eoi      = 0; /* manual EOI from CPU */
  vm->pic.s.slave_pic.imr           = 0xFF; /* all IRQ's initially masked */
  vm->pic.s.slave_pic.isr           = 0x00; /* no IRQ's in service */
  vm->pic.s.slave_pic.irr           = 0x00; /* no IRQ's requested */
  vm->pic.s.slave_pic.read_reg_select = 0; /* IRR */
  vm->pic.s.slave_pic.irq = 0;
  vm->pic.s.slave_pic.INT = 0;
  vm->pic.s.slave_pic.init.in_init = 0;
  vm->pic.s.slave_pic.init.requires_4 = 0;
  vm->pic.s.slave_pic.init.byte_expected = 0;
  vm->pic.s.slave_pic.special_mask = 0;
  vm->pic.s.slave_pic.lowest_priority = 7;
  vm->pic.s.slave_pic.polled = 0;
  vm->pic.s.slave_pic.rotate_on_autoeoi = 0;
}


// new IRQ signal handling routines

  unsigned
picLowerIRQ(vm_t *vm, unsigned irq)
{

  if ((irq <= 7) && (vm->pic.s.master_pic.IRQ_line[irq])) {
    vm->pic.s.master_pic.IRQ_line[irq] = 0;
    vm->pic.s.master_pic.irr &= ~(1 << irq);
    if ((vm->pic.s.master_pic.irr & ~vm->pic.s.master_pic.imr) == 0) {
      setINTR(vm, 0);
      vm->pic.s.master_pic.INT = 0;
    }
  } else if ((irq > 7) && (irq <= 15) &&
             (vm->pic.s.slave_pic.IRQ_line[irq-8])) {
    vm->pic.s.slave_pic.IRQ_line[irq - 8] = 0;
    vm->pic.s.slave_pic.irr &= ~(1 << (irq - 8));
    if ((vm->pic.s.slave_pic.irr & ~vm->pic.s.slave_pic.imr) == 0) {
      vm->pic.s.slave_pic.INT = 0;
      picLowerIRQ(vm, 2);
    }
  } else {
    return(0); /* Error. */
  }
  return(1); /* OK. */
}

  unsigned
picRaiseIRQ(vm_t *vm, unsigned irq)
{
  if ((irq <= 7) && (!vm->pic.s.master_pic.IRQ_line[irq])) {
    vm->pic.s.master_pic.IRQ_line[irq] = 1;
    vm->pic.s.master_pic.irr |= (1 << irq);
    picServiceMaster(vm);
  } else if ((irq > 7) && (irq <= 15) &&
             (!vm->pic.s.slave_pic.IRQ_line[irq-8])) {
    vm->pic.s.slave_pic.IRQ_line[irq - 8] = 1;
    vm->pic.s.slave_pic.irr |= (1 << (irq - 8));
    picServiceSlave(vm);
  } else {
    return(0); /* Error. */
  }
  return(1); /* OK. */
}

void  picClearHighestInterrupt(onePic_t *pic)
{
  int irq;
  int lowest_priority;
  int highest_priority;

  /* clear highest current in service bit */
  lowest_priority = pic->lowest_priority;
  highest_priority = lowest_priority + 1;
  if(highest_priority > 7)
    highest_priority = 0;

  irq = highest_priority;
  do {
    if (pic->isr & (1 << irq)) {
      pic->isr &= ~(1 << irq);
      break; /* Return mask of bit cleared. */
    }

    irq ++;
    if(irq > 7)
      irq = 0;
  } while(irq != highest_priority);

}


  void
picServiceMaster(vm_t *vm)
{
  Bit8u unmasked_requests;
  int irq;
  Bit8u isr, max_irq;
  Bit8u highest_priority = vm->pic.s.master_pic.lowest_priority + 1;
  if(highest_priority > 7)
    highest_priority = 0;

  if (vm->pic.s.master_pic.INT) { /* last interrupt still not acknowleged */
    return;
    }

  if (vm->pic.s.master_pic.special_mask) {
    /* all priorities may be enabled.  check all IRR bits except ones
     * which have corresponding ISR bits set
     */
    max_irq = highest_priority;
    }
  else { /* normal mode */
    /* Find the highest priority IRQ that is enabled due to current ISR */
    isr = vm->pic.s.master_pic.isr;
    if (isr) {
      max_irq = highest_priority;
      while ( (isr & (1 << max_irq)) == 0 ) {
        max_irq++;
	if(max_irq > 7)
	  max_irq = 0;
        }
      if (max_irq == highest_priority ) return; /* Highest priority interrupt in-service,
                                                 * no other priorities allowed */
      if (max_irq > 7) {
        monprint(vm, "error in service_master_pic()\n");
        return;
        }
      }
    else
      max_irq = highest_priority; /* 0..7 bits in ISR are cleared */
    }

  /* now, see if there are any higher priority requests */
  if ((unmasked_requests = (vm->pic.s.master_pic.irr & ~vm->pic.s.master_pic.imr)) ) {
    irq = highest_priority;
    do {
      /* for special mode, since we're looking at all IRQ's, skip if
       * current IRQ is already in-service
       */
      if (! (vm->pic.s.master_pic.special_mask && ((vm->pic.s.master_pic.isr >> irq) & 0x01)) ) {
      if (unmasked_requests & (1 << irq)) {
        vm->pic.s.master_pic.INT = 1;
        setINTR(vm, 1);
        vm->pic.s.master_pic.irq = irq;
        return;
        } /* if (unmasked_requests & ... */
      }

      irq++;
      if(irq > 7)
        irq = 0;
      } while(irq != max_irq); /* do ... */
    } /* if (unmasked_requests = ... */
}

  void
picServiceSlave(vm_t *vm)
{
  Bit8u unmasked_requests;
  int irq;
  Bit8u isr, max_irq;
  Bit8u highest_priority = vm->pic.s.slave_pic.lowest_priority + 1;
  if(highest_priority > 7)
    highest_priority = 0;

  if (vm->pic.s.slave_pic.INT) { /* last interrupt still not acknowleged */
    return;
    }

  if (vm->pic.s.slave_pic.special_mask) {
    /* all priorities may be enabled.  check all IRR bits except ones
     * which have corresponding ISR bits set
     */
    max_irq = highest_priority;
    }
  else { /* normal mode */
    /* Find the highest priority IRQ that is enabled due to current ISR */
    isr = vm->pic.s.slave_pic.isr;
    if (isr) {
      max_irq = highest_priority;
      while ( (isr & (1 << max_irq)) == 0 ) {
        max_irq++;
	if(max_irq > 7)
          max_irq = 0;
        }
      if (max_irq == highest_priority ) return; /* Highest priority interrupt in-service,
                                                 * no other priorities allowed */
      if (max_irq > 7) {
        monprint(vm, "error in service_slave_pic()\n");
        return;
        }
      }
    else
      max_irq = highest_priority;
    }

  /* now, see if there are any higher priority requests */
  if ((unmasked_requests = (vm->pic.s.slave_pic.irr & ~vm->pic.s.slave_pic.imr)) ) {
    irq = highest_priority;
    do {
      /* for special mode, since we're looking at all IRQ's, skip if
       * current IRQ is already in-service
       */
      if (! (vm->pic.s.slave_pic.special_mask && ((vm->pic.s.slave_pic.isr >> irq) & 0x01)) ) {
      if (unmasked_requests & (1 << irq)) {
        vm->pic.s.slave_pic.INT = 1;
        vm->pic.s.slave_pic.irq = irq;
        picRaiseIRQ(vm, 2); /* request IRQ 2 on master pic */
        return;
        } /* if (unmasked_requests & ... */
      }

      irq++;
      if(irq > 7)
        irq = 0;
      } while(irq != max_irq); /* do ... */
    } /* if (unmasked_requests = ... */
}

  Bit8u
picIAC(vm_t *vm)
{
  Bit8u vector;
  Bit8u irq;

  setINTR(vm, 0);
  vm->pic.s.master_pic.INT = 0;
  vm->pic.s.master_pic.irr &= ~(1 << vm->pic.s.master_pic.irq);
  // in autoeoi mode don't set the isr bit.
  if(!vm->pic.s.master_pic.auto_eoi)
    vm->pic.s.master_pic.isr |= (1 << vm->pic.s.master_pic.irq);
  else if(vm->pic.s.master_pic.rotate_on_autoeoi)
    vm->pic.s.master_pic.lowest_priority = vm->pic.s.master_pic.irq;

  if (vm->pic.s.master_pic.irq != 2) {
    irq    = vm->pic.s.master_pic.irq;
    vector = irq + vm->pic.s.master_pic.interrupt_offset;
    }
  else { /* IRQ2 = slave pic IRQ8..15 */
    vm->pic.s.slave_pic.INT = 0;
    vm->pic.s.master_pic.IRQ_line[2] = 0;
    irq    = vm->pic.s.slave_pic.irq;
    vector = irq + vm->pic.s.slave_pic.interrupt_offset;
    vm->pic.s.slave_pic.irr &= ~(1 << vm->pic.s.slave_pic.irq);
    if(!vm->pic.s.slave_pic.auto_eoi)
      vm->pic.s.slave_pic.isr |= (1 << vm->pic.s.slave_pic.irq);
    else if(vm->pic.s.slave_pic.rotate_on_autoeoi)
      vm->pic.s.slave_pic.lowest_priority = vm->pic.s.slave_pic.irq;
    picServiceSlave(vm);
    irq += 8; // for debug printing purposes
    }

  picServiceMaster(vm);

  return(vector);
}
