/************************************************************************
 * $Id: bxemu.cc,v 1.3 2002/08/12 18:43:18 DemonLord Exp $
 ************************************************************************
 *
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The plex86 developers team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

/* This file contains the function used to emulate bochs behavior 
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <string.h>

#include "bxemu.h"
#include "plugin.h"

bx_options_t bx_options; // xxx Fix me, bochs hack

/* new bx_options emulation
 */

// CMOS parameters helper functions
Bit32uParam  cmosOtime0;
pCharParam   cmosOpath;
BooleanParam cmosOcmosImage;

void    bx_options_cmos_set_path(char *path) { bx_options.cmos.path = path; }
char*   bx_options_cmos_get_path(void) { return(bx_options.cmos.path); }
void    bx_options_cmos_set_cmosImage(Boolean cmosImage) { bx_options.cmos.cmosImage = cmosImage; }
Boolean bx_options_cmos_get_cmosImage(void) { return(bx_options.cmos.cmosImage); }
void    bx_options_cmos_set_time0(Bit32u time0) { bx_options.cmos.time0 = time0; }
Bit32u  bx_options_cmos_get_time0(void) { return(bx_options.cmos.time0); }

// FLOPPYA parameters helper functions
StringParam floppyaOpath;
Bit32uParam floppyaOtype;
Bit32uParam floppyaOinitial_status;
Bit32uParam floppyaOdevtype;

void    bx_options_floppya_set_path(char *path) { strcpy(bx_options.floppya.path,path); }
char*   bx_options_floppya_get_path(void) { return(bx_options.floppya.path); }
void    bx_options_floppya_set_type(Bit32u type) { bx_options.floppya.type = type; }
Bit32u  bx_options_floppya_get_type(void) { return(bx_options.floppya.type); }
void    bx_options_floppya_set_status(Bit32u status) { bx_options.floppya.initial_status = status; }
Bit32u  bx_options_floppya_get_status(void) { return(bx_options.floppya.initial_status); }
void    bx_options_floppya_set_devtype(Bit32u devtype) { bx_options.floppya.devtype = devtype; }
Bit32u  bx_options_floppya_get_devtype(void) { return(bx_options.floppya.devtype); }

// FLOPPYB parameters helper functions
StringParam floppybOpath;
Bit32uParam floppybOtype;
Bit32uParam floppybOinitial_status;
Bit32uParam floppybOdevtype;

void    bx_options_floppyb_set_path(char *path) { strcpy(bx_options.floppyb.path,path); }
char*   bx_options_floppyb_get_path(void) { return(bx_options.floppyb.path); }
void    bx_options_floppyb_set_type(Bit32u type) { bx_options.floppyb.type = type; }
Bit32u  bx_options_floppyb_get_type(void) { return(bx_options.floppyb.type); }
void    bx_options_floppyb_set_status(Bit32u status) { bx_options.floppyb.initial_status = status; }
Bit32u  bx_options_floppyb_get_status(void) { return(bx_options.floppyb.initial_status); }
void    bx_options_floppyb_set_devtype(Bit32u devtype) { bx_options.floppyb.devtype = devtype; }
Bit32u  bx_options_floppyb_get_devtype(void) { return(bx_options.floppyb.devtype); }

// FLOPPY_COMMAND_DELAY parameters helper functions
Bit32uParam Ofloppy_command_delay;
void    bx_options_set_floppy_delay(Bit32u floppy_delay) { bx_options.floppy_command_delay = floppy_delay; }
Bit32u  bx_options_get_floppy_delay(void) { return(bx_options.floppy_command_delay); }

// VGA_UPDATE_INTERVAL parameters helper functions
Bit32uParam Ovga_update_interval;
void    bx_options_set_vga_interval(Bit32u vga_interval) { bx_options.vga_update_interval = vga_interval; }
Bit32u  bx_options_get_vga_interval(void) { return(bx_options.vga_update_interval); }

// DISKC parameters helper functions
BooleanParam diskcOpresent;
StringParam  diskcOpath;
Bit32uParam  diskcOcylinders;
Bit32uParam  diskcOheads;
Bit32uParam  diskcOspt;
void    bx_options_diskc_set_present(Boolean present) { bx_options.diskc.present = present; }
Boolean bx_options_diskc_get_present(void) { return(bx_options.diskc.present); }
void    bx_options_diskc_set_path(char *path) { strcpy(bx_options.diskc.path, path); }
char*   bx_options_diskc_get_path(void) { return(bx_options.diskc.path); }
void    bx_options_diskc_set_cylinders(Bit32u cylinders) { bx_options.diskc.cylinders = cylinders; }
Bit32u  bx_options_diskc_get_cylinders(void) { return(bx_options.diskc.cylinders); }
void    bx_options_diskc_set_heads(Bit32u heads) { bx_options.diskc.heads = heads; }
Bit32u  bx_options_diskc_get_heads(void) { return(bx_options.diskc.heads); }
void    bx_options_diskc_set_spt(Bit32u spt) { bx_options.diskc.spt = spt; }
Bit32u  bx_options_diskc_get_spt(void) { return(bx_options.diskc.spt); }

// DISKD parameters helper functions
BooleanParam diskdOpresent;
StringParam  diskdOpath;
Bit32uParam  diskdOcylinders;
Bit32uParam  diskdOheads;
Bit32uParam  diskdOspt;
void    bx_options_diskd_set_present(Boolean present) { bx_options.diskd.present = present; }
Boolean bx_options_diskd_get_present(void) { return(bx_options.diskd.present); }
void    bx_options_diskd_set_path(char *path) { strcpy(bx_options.diskd.path, path); }
char*   bx_options_diskd_get_path(void) { return(bx_options.diskd.path); }
void    bx_options_diskd_set_cylinders(Bit32u cylinders) { bx_options.diskd.cylinders = cylinders; }
Bit32u  bx_options_diskd_get_cylinders(void) { return(bx_options.diskd.cylinders); }
void    bx_options_diskd_set_heads(Bit32u heads) { bx_options.diskd.heads = heads; }
Bit32u  bx_options_diskd_get_heads(void) { return(bx_options.diskd.heads); }
void    bx_options_diskd_set_spt(Bit32u spt) { bx_options.diskd.spt = spt; }
Bit32u  bx_options_diskd_get_spt(void) { return(bx_options.diskd.spt); }

// CDROMD parameters helper functions
BooleanParam cdromdOpresent;
StringParam  cdromdOpath;
BooleanParam cdromdOinserted;
void    bx_options_cdromd_set_present(Boolean present) { bx_options.cdromd.present = present; }
Boolean bx_options_cdromd_get_present(void) { return(bx_options.cdromd.present); }
void    bx_options_cdromd_set_path(char *path) { strcpy(bx_options.cdromd.dev, path); }
char*   bx_options_cdromd_get_path(void) { return(bx_options.cdromd.dev); }
void    bx_options_cdromd_set_inserted(Boolean inserted) { bx_options.cdromd.inserted = inserted; }
Boolean bx_options_cdromd_get_inserted(void) { return(bx_options.cdromd.inserted); }

// BOOTDRIVE parameters helper functions
Bit32uParam  Obootdrive;
void    bx_options_set_bootdrive(Bit32u bootdrive) { 
  if (bootdrive==BX_BOOT_FLOPPYA) strcpy(bx_options.bootdrive,"a");
  if (bootdrive==BX_BOOT_DISKC) strcpy(bx_options.bootdrive,"c");
  if (bootdrive==BX_BOOT_CDROM) strcpy(bx_options.bootdrive,"cdrom");
  }
Bit32u  bx_options_get_bootdrive(void) {  
  if(strcmp(bx_options.bootdrive,"a")==0) return BX_BOOT_FLOPPYA;
  if(strcmp(bx_options.bootdrive,"c")==0) return BX_BOOT_DISKC;
  if(strcmp(bx_options.bootdrive,"cdrom")==0) return BX_BOOT_CDROM;
  return BX_BOOT_FLOPPYA;
  }

// PARPORT1 parameters helper functions
BooleanParam par1Oenable;
StringParam  par1Ooutfile;
void bx_options_par1_set_enable(Boolean par1Enable) { bx_options.par1.enable = par1Enable; }
Boolean bx_options_par1_get_enable(void) { return(bx_options.par1.enable); }
void bx_options_par1_set_outfile(char *outfile) { strcpy(bx_options.par1.outfile,outfile); }
char* bx_options_par1_get_outfile(void) { return(bx_options.par1.outfile); }

// COM1 parameters helper functions
BooleanParam com1Opresent;
StringParam  com1Odev;
void bx_options_com1_set_present(Boolean com1Present) { bx_options.com1.present = com1Present; }
Boolean bx_options_com1_get_present(void) { return(bx_options.com1.present); }
void bx_options_com1_set_dev(char *dev) { strcpy(bx_options.com1.dev,dev); }
char* bx_options_com1_get_dev(void) { return(bx_options.com1.dev); }

// NEWHARDDRIVESUPPRT
BooleanParam OnewHardDriveSupport;
void bx_options_set_newHardDriveSupport(Boolean newHDSupport) { bx_options.newHardDriveSupport = newHDSupport; }
Boolean bx_options_get_newHardDriveSupport(void) { return(bx_options.newHardDriveSupport); }

// KEYBOARD_SERIAL_DELAY
Bit32uParam Okeyboard_serial_delay;
void    bx_options_set_kbd_serial_delay(Bit32u delay) { bx_options.keyboard_serial_delay = delay; }
Bit32u  bx_options_get_kbd_serial_delay(void) { return(bx_options.keyboard_serial_delay); }

// KEYBOARD_PASTE_DELAY
Bit32uParam Okeyboard_paste_delay;
void    bx_options_set_kbd_paste_delay(Bit32u delay) { bx_options.keyboard_paste_delay = delay; }
Bit32u  bx_options_get_kbd_paste_delay(void) { return(bx_options.keyboard_paste_delay); }

// KEYBOARD_TYPE
Bit32uParam Okeyboard_type;
void    bx_options_set_kbd_type(Bit32u type) { bx_options.keyboard_type = type; }
Bit32u  bx_options_get_kbd_type(void) { return(bx_options.keyboard_type); }

// MOUSE_ENABLED
BooleanParam Omouse_enabled;
void    bx_options_set_mouse_enabled(Boolean enabled) { bx_options.mouse_enabled = enabled; }
Boolean bx_options_get_mouse_enabled(void) { return(bx_options.mouse_enabled); }

// PRIVATE_COLORMAP
BooleanParam Oprivate_colormap;
void    bx_options_set_private_colormap(Boolean enabled) { bx_options.private_colormap = enabled; }
Boolean bx_options_get_private_colormap(void) { return(bx_options.private_colormap); }

// KEYBOARD
BooleanParam keyboardOuseMapping;
pCharParam   keyboardOkeymap;
void    bx_options_keyboard_set_useMapping(Boolean use) { bx_options.keyboard.useMapping = use; }
Boolean bx_options_keyboard_get_useMapping(void) { return(bx_options.keyboard.useMapping); }
void    bx_options_keyboard_set_keymap(char *keymap) { bx_options.keyboard.keymap = keymap; }
char*   bx_options_keyboard_get_keymap(void) { return(bx_options.keyboard.keymap); }

// SB16
pCharParam  sb16Omidifile, sb16Owavefile, sb16Ologfile;
Bit32uParam sb16Omidimode, sb16Owavemode, sb16Ologlevel,sb16Odmatimer;
void    bx_options_sb16_set_midifile(char *midifile) { bx_options.sb16.midifile = midifile; }
char*   bx_options_sb16_get_midifile(void) { return(bx_options.sb16.midifile); }
void    bx_options_sb16_set_wavefile(char *wavefile) { bx_options.sb16.wavefile = wavefile; }
char*   bx_options_sb16_get_wavefile(void) { return(bx_options.sb16.wavefile); }
void    bx_options_sb16_set_logfile(char *logfile) { bx_options.sb16.logfile = logfile; }
char*   bx_options_sb16_get_logfile(void) { return(bx_options.sb16.logfile); }
void    bx_options_sb16_set_midimode(Bit32u midimode) { bx_options.sb16.midimode = midimode; }
Bit32u  bx_options_sb16_get_midimode(void) { return(bx_options.sb16.midimode); }
void    bx_options_sb16_set_wavemode(Bit32u wavemode) { bx_options.sb16.wavemode = wavemode; }
Bit32u  bx_options_sb16_get_wavemode(void) { return(bx_options.sb16.wavemode); }
void    bx_options_sb16_set_loglevel(Bit32u loglevel) { bx_options.sb16.loglevel = loglevel; }
Bit32u  bx_options_sb16_get_loglevel(void) { return(bx_options.sb16.loglevel); }
void    bx_options_sb16_set_dmatimer(Bit32u dmatimer) { bx_options.sb16.dmatimer = dmatimer; }
Bit32u  bx_options_sb16_get_dmatimer(void) { return(bx_options.sb16.dmatimer); }

// i440FX
BooleanParam Oi440FXSupport;
void    bx_options_set_i440FXSupport(Boolean support) { bx_options.i440FXSupport = support; }
Boolean bx_options_get_i440FXSupport(void) { return(bx_options.i440FXSupport); }

// NE2K
Bit32sParam   ne2kOvalid;
Bit32uParam   ne2kOioaddr, ne2kOirq;
StringParam   ne2kOmacaddr;
pCharParam    ne2kOethmod, ne2kOethdev;
void    bx_options_ne2k_set_valid(Bit32s valid) { bx_options.ne2k.valid = valid; }
Bit32s  bx_options_ne2k_get_valid(void) { return(bx_options.ne2k.valid); }
void    bx_options_ne2k_set_ioaddr(Bit32u ioaddr) { bx_options.ne2k.ioaddr = ioaddr; }
Bit32u  bx_options_ne2k_get_ioaddr(void) { return(bx_options.ne2k.ioaddr); }
void    bx_options_ne2k_set_irq(Bit32u irq) { bx_options.ne2k.irq = irq; }
Bit32u  bx_options_ne2k_get_irq(void) { return(bx_options.ne2k.irq); }
void    bx_options_ne2k_set_macaddr(char *macaddr) { memcpy(bx_options.ne2k.macaddr, macaddr,6); }
char*   bx_options_ne2k_get_macaddr(void) { return((char*)bx_options.ne2k.macaddr); }
void    bx_options_ne2k_set_ethmod(char *ethmod) { bx_options.ne2k.ethmod = ethmod; }
char*   bx_options_ne2k_get_ethmod(void) { return(bx_options.ne2k.ethmod); }
void    bx_options_ne2k_set_ethdev(char *ethdev) { bx_options.ne2k.ethdev = ethdev; }
char*   bx_options_ne2k_get_ethdev(void) { return(bx_options.ne2k.ethdev); }

// User button shortcut
StringParam   userbuttonOuser_shortcut;
void    bx_options_set_Ouser_shortcut(char *user_shortcut) { strcpy(bx_options.usershortcut.shortcut, user_shortcut); }
char*   bx_options_get_Ouser_shortcut(void) { return(bx_options.usershortcut.shortcut); }



// Initialisation
  void
bxemu_init(void)
{
  // clear option memory
  memset(&bx_options, 0, sizeof(bx_options));

  // set the callbacks to the bx_options
  // CMOS
  cmosOpath.getptr=bx_options_cmos_get_path;
  cmosOpath.setptr=bx_options_cmos_set_path;
  bx_options.cmos.Opath = &cmosOpath;
  cmosOcmosImage.get=bx_options_cmos_get_cmosImage;
  cmosOcmosImage.set=bx_options_cmos_set_cmosImage;
  bx_options.cmos.OcmosImage = &cmosOcmosImage;
  cmosOtime0.get = bx_options_cmos_get_time0;
  cmosOtime0.set = bx_options_cmos_set_time0;
  bx_options.cmos.Otime0 = &cmosOtime0;

  // FLOPPYA
  floppyaOpath.getptr=bx_options_floppya_get_path;
  floppyaOpath.setptr=bx_options_floppya_set_path;
  bx_options.floppya.Opath = &floppyaOpath;
  floppyaOtype.get = bx_options_floppya_get_type;
  floppyaOtype.set = bx_options_floppya_set_type;
  bx_options.floppya.Otype = &floppyaOtype;
  floppyaOinitial_status.get = bx_options_floppya_get_status;
  floppyaOinitial_status.set = bx_options_floppya_set_status;
  bx_options.floppya.Ostatus = &floppyaOinitial_status;
  floppyaOdevtype.get = bx_options_floppya_get_devtype;
  floppyaOdevtype.set = bx_options_floppya_set_devtype;
  bx_options.floppya.Odevtype = &floppyaOdevtype;

  // FLOPPYB
  floppybOpath.getptr=bx_options_floppyb_get_path;
  floppybOpath.setptr=bx_options_floppyb_set_path;
  bx_options.floppyb.Opath = &floppybOpath;
  floppybOtype.get = bx_options_floppyb_get_type;
  floppybOtype.set = bx_options_floppyb_set_type;
  bx_options.floppyb.Otype = &floppybOtype;
  floppybOinitial_status.get = bx_options_floppyb_get_status;
  floppybOinitial_status.set = bx_options_floppyb_set_status;
  bx_options.floppyb.Ostatus = &floppybOinitial_status;
  floppybOdevtype.get = bx_options_floppyb_get_devtype;
  floppybOdevtype.set = bx_options_floppyb_set_devtype;
  bx_options.floppyb.Odevtype = &floppybOdevtype;

  // FLOPPY_COMMAND_DELAY
  Ofloppy_command_delay.get = bx_options_get_floppy_delay;
  Ofloppy_command_delay.set = bx_options_set_floppy_delay;
  bx_options.Ofloppy_command_delay = &Ofloppy_command_delay;

  // VGA_UPDATE_INTERVAL
  Ovga_update_interval.get = bx_options_get_vga_interval;
  Ovga_update_interval.set = bx_options_set_vga_interval;
  bx_options.Ovga_update_interval = &Ovga_update_interval;

  // DISKC
  diskcOpresent.get = bx_options_diskc_get_present;
  diskcOpresent.set = bx_options_diskc_set_present;
  bx_options.diskc.Opresent = &diskcOpresent;
  diskcOpath.getptr = bx_options_diskc_get_path;
  diskcOpath.setptr = bx_options_diskc_set_path;
  bx_options.diskc.Opath = &diskcOpath;
  diskcOcylinders.get = bx_options_diskc_get_cylinders;
  diskcOcylinders.set = bx_options_diskc_set_cylinders;
  bx_options.diskc.Ocylinders = &diskcOcylinders;
  diskcOheads.get = bx_options_diskc_get_heads;
  diskcOheads.set = bx_options_diskc_set_heads;
  bx_options.diskc.Oheads = &diskcOheads;
  diskcOspt.get = bx_options_diskc_get_spt;
  diskcOspt.set = bx_options_diskc_set_spt;
  bx_options.diskc.Ospt = &diskcOspt;

  // DISKD
  diskdOpresent.get = bx_options_diskd_get_present;
  diskdOpresent.set = bx_options_diskd_set_present;
  bx_options.diskd.Opresent = &diskdOpresent;
  diskdOpath.getptr = bx_options_diskd_get_path;
  diskdOpath.setptr = bx_options_diskd_set_path;
  bx_options.diskd.Opath = &diskdOpath;
  diskdOcylinders.get = bx_options_diskd_get_cylinders;
  diskdOcylinders.set = bx_options_diskd_set_cylinders;
  bx_options.diskd.Ocylinders = &diskdOcylinders;
  diskdOheads.get = bx_options_diskd_get_heads;
  diskdOheads.set = bx_options_diskd_set_heads;
  bx_options.diskd.Oheads = &diskdOheads;
  diskdOspt.get = bx_options_diskd_get_spt;
  diskdOspt.set = bx_options_diskd_set_spt;
  bx_options.diskd.Ospt = &diskdOspt;

  // CDROMD
  cdromdOpresent.get = bx_options_cdromd_get_present;
  cdromdOpresent.set = bx_options_cdromd_set_present;
  bx_options.cdromd.Opresent = &cdromdOpresent;
  cdromdOpath.getptr = bx_options_cdromd_get_path;
  cdromdOpath.setptr = bx_options_cdromd_set_path;
  bx_options.cdromd.Opath = &cdromdOpath;
  cdromdOinserted.get = bx_options_cdromd_get_inserted;
  cdromdOinserted.set = bx_options_cdromd_set_inserted;
  bx_options.cdromd.Ostatus = &cdromdOinserted;

  // BOOTDRIVE parameters helper functions
  Obootdrive.get = bx_options_get_bootdrive;
  Obootdrive.set = bx_options_set_bootdrive;
  bx_options.Obootdrive = &Obootdrive;
  bx_options.Obootdrive->set(BX_BOOT_DISKC);

  // COM1
  com1Opresent.get=bx_options_com1_get_present;
  com1Opresent.set=bx_options_com1_set_present;
  bx_options.com1.Opresent = &com1Opresent;
  com1Odev.getptr=bx_options_com1_get_dev;
  com1Odev.setptr=bx_options_com1_set_dev;
  bx_options.com1.Odev = &com1Odev;

  // PARPORT1
  par1Oenable.get=bx_options_par1_get_enable;
  par1Oenable.set=bx_options_par1_set_enable;
  bx_options.par1.Oenable = &par1Oenable;
  par1Ooutfile.getptr=bx_options_par1_get_outfile;
  par1Ooutfile.setptr=bx_options_par1_set_outfile;
  bx_options.par1.Ooutfile = &par1Ooutfile;

  // NEWHARDDRIVESUPPRT
  OnewHardDriveSupport.get=bx_options_get_newHardDriveSupport;
  OnewHardDriveSupport.set=bx_options_set_newHardDriveSupport;
  bx_options.OnewHardDriveSupport = &OnewHardDriveSupport;

  // KEYBOARD_SERIAL_DELAY
  Okeyboard_serial_delay.get=bx_options_get_kbd_serial_delay;
  Okeyboard_serial_delay.set=bx_options_set_kbd_serial_delay;
  bx_options.Okeyboard_serial_delay = &Okeyboard_serial_delay;

  // KEYBOARD_PASTE_DELAY
  Okeyboard_paste_delay.get=bx_options_get_kbd_paste_delay;
  Okeyboard_paste_delay.set=bx_options_set_kbd_paste_delay;
  bx_options.Okeyboard_paste_delay = &Okeyboard_paste_delay;
  bx_options.Okeyboard_paste_delay->set(100000);

  // KEYBOARD_TYPE
  Okeyboard_type.get=bx_options_get_kbd_type;
  Okeyboard_type.set=bx_options_set_kbd_type;
  bx_options.Okeyboard_type = &Okeyboard_type;
  bx_options.Okeyboard_type->set(BX_KBD_MF_TYPE);

  // MOUSE_ENABLED
  Omouse_enabled.get=bx_options_get_mouse_enabled;
  Omouse_enabled.set=bx_options_set_mouse_enabled;
  bx_options.Omouse_enabled = &Omouse_enabled;

  // PRIVATE_COLORMAP
  Oprivate_colormap.get=bx_options_get_private_colormap;
  Oprivate_colormap.set=bx_options_set_private_colormap;
  bx_options.Oprivate_colormap = &Oprivate_colormap;

  // KEYBOARD
  keyboardOuseMapping.get=bx_options_keyboard_get_useMapping;
  keyboardOuseMapping.set=bx_options_keyboard_set_useMapping;
  bx_options.keyboard.OuseMapping = &keyboardOuseMapping;
  keyboardOkeymap.getptr=bx_options_keyboard_get_keymap;
  keyboardOkeymap.setptr=bx_options_keyboard_set_keymap;
  bx_options.keyboard.Okeymap = &keyboardOkeymap;
  
  // SB16
  sb16Omidifile.getptr=bx_options_sb16_get_midifile;
  sb16Omidifile.setptr=bx_options_sb16_set_midifile;
  bx_options.sb16.Omidifile = &sb16Omidifile;
  sb16Owavefile.getptr=bx_options_sb16_get_wavefile;
  sb16Owavefile.setptr=bx_options_sb16_set_wavefile;
  bx_options.sb16.Owavefile = &sb16Owavefile;
  sb16Ologfile.getptr=bx_options_sb16_get_logfile;
  sb16Ologfile.setptr=bx_options_sb16_set_logfile;
  bx_options.sb16.Ologfile = &sb16Ologfile;
  sb16Omidimode.get=bx_options_sb16_get_midimode;
  sb16Omidimode.set=bx_options_sb16_set_midimode;
  bx_options.sb16.Omidimode = &sb16Omidimode;
  sb16Owavemode.get=bx_options_sb16_get_wavemode;
  sb16Owavemode.set=bx_options_sb16_set_wavemode;
  bx_options.sb16.Owavemode = &sb16Owavemode;
  sb16Ologlevel.get=bx_options_sb16_get_loglevel;
  sb16Ologlevel.set=bx_options_sb16_set_loglevel;
  bx_options.sb16.Ologlevel = &sb16Ologlevel;
  sb16Odmatimer.get=bx_options_sb16_get_dmatimer;
  sb16Odmatimer.set=bx_options_sb16_set_dmatimer;
  bx_options.sb16.Odmatimer = &sb16Odmatimer;

  // i440FX
  Oi440FXSupport.get=bx_options_get_i440FXSupport;
  Oi440FXSupport.set=bx_options_set_i440FXSupport;
  bx_options.Oi440FXSupport = &Oi440FXSupport;

  // NE2K
  ne2kOvalid.get=bx_options_ne2k_get_valid;
  ne2kOvalid.set=bx_options_ne2k_set_valid;
  bx_options.ne2k.Ovalid = &ne2kOvalid;
  ne2kOioaddr.get=bx_options_ne2k_get_ioaddr;
  ne2kOioaddr.set=bx_options_ne2k_set_ioaddr;
  bx_options.ne2k.Oioaddr = &ne2kOioaddr;
  ne2kOirq.get=bx_options_ne2k_get_irq;
  ne2kOirq.set=bx_options_ne2k_set_irq;
  bx_options.ne2k.Oirq = &ne2kOirq;
  ne2kOmacaddr.getptr=bx_options_ne2k_get_macaddr;
  ne2kOmacaddr.setptr=bx_options_ne2k_set_macaddr;
  bx_options.ne2k.Omacaddr = &ne2kOmacaddr;
  ne2kOethmod.getptr=bx_options_ne2k_get_ethmod;
  ne2kOethmod.setptr=bx_options_ne2k_set_ethmod;
  bx_options.ne2k.Oethmod = &ne2kOethmod;
  ne2kOethdev.getptr=bx_options_ne2k_get_ethdev;
  ne2kOethdev.setptr=bx_options_ne2k_set_ethdev;
  bx_options.ne2k.Oethdev = &ne2kOethdev;

  // User button shortcut
  userbuttonOuser_shortcut.getptr=bx_options_get_Ouser_shortcut;
  userbuttonOuser_shortcut.setptr=bx_options_set_Ouser_shortcut;
  bx_options.Ouser_shortcut = &userbuttonOuser_shortcut;
}


/* log emulation
 */

logfunctions::logfunctions(void)
{
        prefix = NULL;
        put(" ");
}

logfunctions::~logfunctions(void)
{
	// clean up
	if(prefix != NULL) free(prefix);
}

void logfunctions::info(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);

	fprintf(stderr,"[%-5s] <INFO>  ",prefix);
	vfprintf(stderr,fmt,ap);
	fprintf(stderr,"\n");

	va_end(ap);
}
void logfunctions::error(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);

	fprintf(stderr,"[%-5s] <ERROR> ",prefix);
	vfprintf(stderr,fmt,ap);
	fprintf(stderr,"\n");

	va_end(ap);
}
void logfunctions::panic(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);

	fprintf(stderr,"[%-5s] >>>PANIC<<< ",prefix);
	vfprintf(stderr,fmt,ap);
	fprintf(stderr,"\n");

	va_end(ap);

	plugin_abort();
}
void logfunctions::ldebug(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);

	fprintf(stderr,"[%-5s] <DEBUG> ",prefix);
	vfprintf(stderr,fmt,ap);
	fprintf(stderr,"\n");

	va_end(ap);
}

void logfunctions::put(char *newprefix)
{
	if(prefix != NULL) free(prefix);
	prefix = (char*)malloc(strlen(newprefix)+1);
	strncpy(prefix,newprefix,5);
	prefix[5]=0;
}


/* state file emulation
 */

#define LOG_THIS log->

FILE *state_file::get_handle()
{
  BX_INFO(("state_file::get_handle()"));
  return NULL;
}
	
void state_file::write(Bit8u)
{
  BX_PANIC(("state_file::write(Bit8u)"));
}

void state_file::write(Bit16u)
{
  BX_PANIC(("state_file::write(Bit16u)"));
}

void state_file::write(Bit32u)
{
  BX_PANIC(("state_file::write(Bit32u)"));
}

void state_file::write(Bit64u)
{
  BX_PANIC(("state_file::write(Bit64u)"));
}

void state_file::write(const void *, size_t)
{
  BX_PANIC(("state_file::write(const void *, size_t)"));
}

void state_file::read(Bit8u &)
{
  BX_PANIC(("state_file::read(uint8 &)"));
}

void state_file::read(Bit16u &)
{
  BX_PANIC(("state_file::read(uint16 &)"));
}

void state_file::read(Bit32u &)
{
  BX_PANIC(("state_file::read(uint32 &)"));
}

void state_file::read(Bit64u &)
{
  BX_PANIC(("state_file::read(uint64 &)"));
}

void state_file::read(void *, size_t)
{
  BX_PANIC(("state_file::read(void *, size_t)"));
}

void state_file::write_check(const char *)
{
  BX_PANIC(("state_file::write_check()"));
}

void state_file::read_check (const char *)
{
  BX_PANIC(("state_file::read_check()"));
}

void
state_file::init(void)
{
	log = new class logfunctions();
	log->put("STAT");
	log->settype(GENLOG);
}


state_file::state_file (const char *name, const char *options)
{
  UNUSED(name);
  UNUSED(options);
  init();
  BX_DEBUG(( "Init(const char *, const char *)." ));
}

state_file::state_file (FILE *f)
{
  UNUSED(f);
  init();
  BX_INFO(("Init(FILE *)."));
}

state_file::~state_file()
{
  BX_DEBUG(("Exit."));
  if ( log != NULL )
  {
        delete log;
        log = NULL;
  }
}
