/*
    pmacct (Promiscuous mode IP Accounting package)
    pmacct is Copyright (C) 2004 by Paolo Lucente
*/

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if no, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#define __PKT_HANDLERS_C

/* includes */
#include "pmacct.h"
#include "plugin_hooks.h"
#include "pkt_handlers.h"

/* functions */
void evaluate_packet_handlers()
{
  int primitives, index = 0;

  while (channels_list[index].aggregation) { 
    primitives = 0;
    memset(&channels_list[index].phandler, 0, N_PRIMITIVES);

    if (channels_list[index].aggregation & COUNT_SRC_MAC) {
      channels_list[index].phandler[primitives] = src_mac_handler;
      primitives++;
    }

    if (channels_list[index].aggregation & COUNT_DST_MAC) {
      channels_list[index].phandler[primitives] = dst_mac_handler;
      primitives++;
    }

    if (channels_list[index].aggregation & COUNT_SRC_HOST) {
      channels_list[index].phandler[primitives] = src_host_handler;
      primitives++;
    }

    if (channels_list[index].aggregation & COUNT_DST_HOST) {
      channels_list[index].phandler[primitives] = dst_host_handler;
      primitives++;
    }

    if (channels_list[index].aggregation & COUNT_SRC_PORT) {
      channels_list[index].phandler[primitives] = src_port_handler;
      primitives++;
    }

    if (channels_list[index].aggregation & COUNT_DST_PORT) {
      channels_list[index].phandler[primitives] = dst_port_handler;
      primitives++;
    }

    if (channels_list[index].aggregation & COUNT_SUM_HOST) {
      channels_list[index].phandler[primitives] = src_host_handler;
      primitives++;
      channels_list[index].phandler[primitives] = dst_host_handler;
      primitives++;
    }

    if (channels_list[index].aggregation & COUNT_IP_PROTO) {
      channels_list[index].phandler[primitives] = ip_proto_handler;
      primitives++;
    }

    index++;
  }
}

void src_mac_handler(struct packet_ptrs *pptrs, struct pkt_data *pdata)
{
  memcpy(pdata->primitives.eth_shost, (pptrs->mac_ptr+ETH_ADDR_LEN), ETH_ADDR_LEN); 
}

void dst_mac_handler(struct packet_ptrs *pptrs, struct pkt_data *pdata)
{
  memcpy(pdata->primitives.eth_dhost, pptrs->mac_ptr, ETH_ADDR_LEN);
}

void src_host_handler(struct packet_ptrs *pptrs, struct pkt_data *pdata)
{
  pdata->primitives.src_ip.s_addr = ((struct my_iphdr *) pptrs->iph_ptr)->ip_src.s_addr;
}

void dst_host_handler(struct packet_ptrs *pptrs, struct pkt_data *pdata)
{
  pdata->primitives.dst_ip.s_addr = ((struct my_iphdr *) pptrs->iph_ptr)->ip_dst.s_addr;
}

void src_port_handler(struct packet_ptrs *pptrs, struct pkt_data *pdata)
{
  if ((((struct my_iphdr *) pptrs->iph_ptr)->ip_p == IPPROTO_UDP) ||
      ((struct my_iphdr *) pptrs->iph_ptr)->ip_p == IPPROTO_TCP)
    pdata->primitives.src_port = ntohs(((struct my_tlhdr *) pptrs->tlh_ptr)->src_port);
  else pdata->primitives.src_port = 0;
}

void dst_port_handler(struct packet_ptrs *pptrs, struct pkt_data *pdata)
{
  if ((((struct my_iphdr *) pptrs->iph_ptr)->ip_p == IPPROTO_UDP) ||
      ((struct my_iphdr *) pptrs->iph_ptr)->ip_p == IPPROTO_TCP)
    pdata->primitives.dst_port = ntohs(((struct my_tlhdr *) pptrs->tlh_ptr)->dst_port);
  else pdata->primitives.dst_port = 0;
}

void ip_proto_handler(struct packet_ptrs *pptrs, struct pkt_data *pdata)
{
  pdata->primitives.proto = ((struct my_iphdr *) pptrs->iph_ptr)->ip_p;
}

