/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.CRCInputStream;
import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.ExDataInputStream;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngExceptionSoft;
import com.sixlegs.image.png.PngImage;
import java.io.IOException;
import java.io.InputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class IDATInputStream
extends InputStream {
    private static final int[] signature = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
    private InputStream in_raw;
    private CRCInputStream in_crc;
    private ExDataInputStream in_data;
    private PngImage img;
    private Chunk cur;
    private int chunk_left;
    private boolean close;
    private byte[] _b;

    final void readToData() throws IOException {
        if (this.cur != null) {
            return;
        }
        int n = 0;
        while (n < 8) {
            if (this.in_data.readUnsignedByte() != signature[n]) {
                throw new PngException("Improper signature");
            }
            ++n;
        }
        try {
            if (this.getNextChunk().type != Chunk.IHDR) {
                throw new PngException("IHDR chunk must be first chunk");
            }
            while (this.getNextChunk().type != Chunk.IDAT) {
            }
            if (this.img.data.palette == null && this.img.data.header.paletteUsed) {
                throw new PngException("Required PLTE chunk not found");
            }
            this.img.fillGammaTable();
        }
        catch (NullPointerException nullPointerException) {
            throw new PngException("Can't find data chunk");
        }
    }

    final int count() {
        return this.in_crc.count();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readChunk(Chunk chunk) throws IOException {
        try {
            try {
                if (!chunk.multipleOK() && this.img.getChunk(chunk.type) != null) {
                    String string = "Multiple " + Chunk.typeToString(chunk.type) + " chunks are not allowed";
                    if (chunk.isAncillary()) {
                        throw new PngExceptionSoft(string);
                    }
                    throw new PngException(string);
                }
                chunk.readData();
                this.img.putChunk(chunk.type, chunk);
            }
            catch (PngExceptionSoft pngExceptionSoft) {
                if (PngImage.allFatal) {
                    throw pngExceptionSoft;
                }
                this.img.addError(pngExceptionSoft);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.in_data.skipBytes(chunk.bytesRemaining());
            long l = this.in_crc.getValue();
            long l2 = this.in_data.readUnsignedInt();
            if (l != l2) {
                throw new PngException("Bad CRC value for " + Chunk.typeToString(chunk.type) + " chunk");
            }
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.in_data.skipBytes(chunk.bytesRemaining());
        long l = this.in_crc.getValue();
        long l3 = this.in_data.readUnsignedInt();
        if (l != l3) {
            throw new PngException("Bad CRC value for " + Chunk.typeToString(chunk.type) + " chunk");
        }
    }

    private final Chunk getNextChunk() throws IOException {
        if (this.cur != null) {
            this.readChunk(this.cur);
            if (this.cur.type == Chunk.IEND) {
                return null;
            }
        }
        this.chunk_left = this.in_data.readInt();
        this.in_crc.reset();
        int n = this.in_data.readInt();
        if (this.chunk_left < 0) {
            throw new PngException("Bad " + Chunk.typeToString(n) + " chunk length: " + ExDataInputStream.unsign(this.chunk_left));
        }
        this.cur = PngImage.getRegisteredChunk(n);
        this.cur.img = this.img;
        this.cur.length = this.chunk_left;
        this.cur.in_data = this.in_data;
        if (this.cur.isUnknown()) {
            String string = Chunk.typeToString(n);
            if (!this.cur.isAncillary()) {
                throw new PngException("Private critical chunk encountered: " + string);
            }
            int n2 = 0;
            while (n2 < 4) {
                char c = string.charAt(n2);
                if (c < 'A' || c > 'Z' && c < 'a' || c > 'z') {
                    throw new PngException("Corrupted chunk type: " + string);
                }
                ++n2;
            }
        }
        return this.cur;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.cur == null) {
            this.readToData();
        }
        if (this.chunk_left == 0) {
            return -1;
        }
        int n3 = this.chunk_left < n2 ? this.chunk_left : n2;
        this.in_data.readFully(byArray, n, n3);
        this.chunk_left -= n3;
        if (this.chunk_left == 0 && this.getNextChunk().type != Chunk.IDAT) {
            Chunk chunk;
            while ((chunk = this.getNextChunk()) != null) {
                if (!chunk.beforeIDAT()) continue;
                throw new PngException(Chunk.typeToString(chunk.type) + " chunk must precede first IDAT chunk");
            }
            if (this.close) {
                this.close();
            }
        }
        return n3;
    }

    public final int read() throws IOException {
        return this.read(this._b, 0, 1) > 0 ? this._b[0] & 0xFF : -1;
    }

    public final void close() throws IOException {
        this.in_data.close();
    }

    private final /* synthetic */ void this() {
        this._b = new byte[1];
    }

    public IDATInputStream(PngImage pngImage, InputStream inputStream, boolean bl) {
        this.this();
        this.img = pngImage;
        this.in_raw = inputStream;
        this.close = bl;
        this.in_crc = new CRCInputStream(inputStream);
        this.in_data = new ExDataInputStream(this.in_crc);
    }
}

