package HTML;

# This file is part of the pnopaste program
# Copyright (C) 2008-2009 Patrick Matthäi <patrick@linux-dev.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

use warnings;
no warnings 'once';
use strict;
use lib::Benchmark;
use lib::Database;
use lib::Expire;
use lib::Format;
use lib::Skin;
use lib::Highlighting;
use lib::Version;


# Shows the confirm page with the ID link.
sub Confirm {
	my($ID, $Self_URL) = @_;

	Header();

	List_Confirm($ID, $Self_URL);

	Footer();
}


### Shows errors and exits.
sub Error {
	my($Error_ID) = @_;

	# ErrorID List.
	my %Errors = (
		1	=> 'Invalid expire time.',
		2	=> 'Your Hostname is blacklisted.',
		3	=> 'You used one or more badwords in the code fields.',
		4	=> 'The given code language is not present.'
	);

	Header();

	print $Errors{$Error_ID}, "\n";

	Footer();
}


### Adds html header and stylesheet.
sub Header {

	# The content type. This is the reason, why Header()
	# is only allowed to be called once in an session.
	print "Content-type: text/html\n\n";

	my $Style = Skin::Get_Skin();
	my $Title = Skin::Get_Title();

	open(HEAD,'<','./templates/header.tmpl') or return;
	while(<HEAD>){
		$_ =~ s/#STYLE#/$Style/g;
		$_ =~ s/#TITLE#/$Title/g;
		print;
	}
	close(HEAD);
}


### Adds html footer.
sub Footer {
	open(FOOT,'<','./templates/footer.tmpl') or return;

	my $Version	= $Version::Build;
	my $Needed	= Benchmark::Calculate();

	while(<FOOT>){
		$_ =~ s/#RENDERTIME#/$Needed/g;
		$_ =~ s/#VERSION#/$Version/g;
		print;
	}
	close(FOOT);

	exit(0);
}


### Adds add form page.
sub Add_Form {
	my($FullURL) = @_;

	my $Timeoptions = Expire::Build_Time_List_HTML();
	my $Langoptions = Highlighting::Build_Syntax_List_HTML();


	open(ADD,'<','./templates/list_addform.tmpl') or return;

	while(<ADD>){
		# Replace the template url with the real one for POST.
		$_ =~ s/#SCRIPTNAME#/$FullURL/g;
		# Insert timesheet lists.
		$_ =~ s/#TIMELISTOPTIONS#/$Timeoptions/g;
		# Insert Syntax HL options.
		$_ =~ s/#LANGUAGEOPTIONS#/$Langoptions/g;

		print;
	}

	close(ADD);
}


### Creates the confirm page from the template.
sub List_Confirm {
	my($ID, $FullURL) = @_;

	# Add the '?<ID>' to the Full URL.
	my $FullURL_ID = $FullURL . '?' . $ID;

	open(CONFIRM,'<','./templates/list_confirm.tmpl') or return;

	while(<CONFIRM>){
		# Replace the template url with the real one for POST.
		$_ =~ s/#LINKCODE#/$FullURL_ID/g;
		$_ =~ s/#URLCODE#/$FullURL/g;
		print;
	}

	close(CONFIRM);
}


### Display the html main add page.
sub Add {
	my($URL) = @_;

	Header();
	Add_Form($URL);
	Footer();
}


### Displays a code.
sub Code {
	my($ID, $Download, $BaseURL) = @_;

	my $Query = 'SELECT name,description,code,time,ip,language FROM `nopaste` WHERE id = ? LIMIT 1';
	$Query = $Database::dbh->prepare($Query);
	$Query->execute($ID);

	my $List = $Query->fetchrow_hashref();
	if(!$List){
		Add();
	}

	# Declarations and some failovers.
	my $Time		= localtime($List->{'time'});
	my $Author		= $List->{'name'}			|| 'Anonymous';
	my $Description	= $List->{'description'}	|| 'The user has not left a description.';
	my $Code		= $List->{'code'}			|| '';
	my $IP			= $List->{'ip'};
	my $Syntax_HL	= $List->{'language'}		|| 'Plain';
	my $Expires		= Expire::Get_Expire($ID);


	# We have to change the content-type for downloads.
	if($Download){
		print "Content-type: text/plain\n\n";
		print $Code;
		exit(0);
	}


	$Author .= ' (' . $IP . ')';

	my($Code_Lines, $Code_Text) = Format::To_HTML($Code, $Syntax_HL, 1);
	my($Desc_Lines, $Desc_Text) = Format::To_HTML($Description, $Syntax_HL, 0);

	my $Line_Numbers = Format::Build_Line_Numbers($Code_Lines);

	my $Get_Link = '<a href="' . $BaseURL . '?' . $ID . '&download">Here</a>';
	my $New_Link = '<a href="' . $BaseURL . '">Here</a>';

	Header();

	# Write authors part.
	my $Tmpl_Authors = '';

	open(AUTHORS,'<','./templates/list_table_author.tmpl') or return;
	while(<AUTHORS>){
		$Tmpl_Authors .= $_;
	}
	close(AUTHORS);

	$Tmpl_Authors =~ s/#TIME#/$Time/g;
	$Tmpl_Authors =~ s/#LANGUAGE#/$Syntax_HL/g;
	$Tmpl_Authors =~ s/#EXPIRES#/$Expires/g;
	$Tmpl_Authors =~ s/#LINENUMBERS#/$Line_Numbers/g;
	$Tmpl_Authors =~ s/#DOWNLOAD#/$Get_Link/g;
	$Tmpl_Authors =~ s/#ADD_NEW#/$New_Link/g;
	$Tmpl_Authors =~ s/#AUTHOR#/$Author/g;


	# Write desc part.
	my $Tmpl_Desc = '';

	open(DESC,'<','./templates/list_table_desc.tmpl') or return;
	while(<DESC>){
		$Tmpl_Desc .= $_;
	}
	close(DESC);

	$Tmpl_Desc =~ s/#LINENUMBERS#/$Line_Numbers/g;
	$Tmpl_Desc =~ s/#DESCRIPTION#/$Desc_Text/g;


	# Write code part.
	my $Tmpl_Code = '';

	open(CODE,'<','./templates/list_table_code.tmpl') or return;
	while(<CODE>){
		$Tmpl_Code .= $_;
	}
	close(CODE);

	$Tmpl_Code =~ s/#CODETEXT#/$Code_Text/g;

	print $Tmpl_Authors, $Tmpl_Desc, $Tmpl_Code;

	# Print footer.
	Footer();

}


1;
