using System;

using NDesk.DBus;

namespace PodSleuth.HalFrontend
{
    public class DkDisk
    {
        public static DkDisk FindByDevice (string device_path)
        {
            if (device_path == null)
                return null;

            if (disks == null)
                return null;


            string disk_path = null;
            try {
                disk_path = disks.FindDeviceByDeviceFile (device_path);
            } catch {}

            if (disk_path == null)
                return null;

            try {
                return new DkDisk (disk_path);
            } catch {}

            return null;
        }

        private IDkDisk disk;
        private org.freedesktop.DBus.Properties props;

        private DkDisk (string obj_path)
        {
            disk = Bus.System.GetObject<IDkDisk>("org.freedesktop.DeviceKit.Disks",
                new ObjectPath(obj_path));

            props = Bus.System.GetObject<org.freedesktop.DBus.Properties>("org.freedesktop.DeviceKit.Disks",
                new ObjectPath(obj_path));
        }

        public bool IsMounted {
            get {
                return (bool) props.Get ("org.freedesktop.DeviceKit.Disks.Device", "DeviceIsMounted");
            }
        }

        public bool IsReadOnly {
            get {
                return (bool) props.Get ("org.freedesktop.DeviceKit.Disks.Device", "DeviceIsReadOnly");
            }
        }

        public string MountPoint {
            get {
                var ary = (string[])props.Get ("org.freedesktop.DeviceKit.Disks.Device", "DeviceMountPaths");
                return ary != null && ary.Length > 0 ? ary[0] : null;
            }
        }

        private static IDkDisks disks;

        static DkDisk ()
        {
            try {
                disks = Bus.System.GetObject<IDkDisks>("org.freedesktop.DeviceKit.Disks",
                    new ObjectPath("/org/freedesktop/DeviceKit/Disks"));
            } catch {}
        }

        [Interface("org.freedesktop.DeviceKit.Disks")]
        internal interface IDkDisks
        {
            string FindDeviceByDeviceFile (string deviceFile);
        }

    }

    [Interface("org.freedesktop.DeviceKit.Disks.Device")]
    public interface IDkDisk
    {
        bool DeviceIsMounted { get; }
        string [] DeviceMountPaths { get; }
    }
}
