// ------------------------------------------------------------------------- //
// $Id: image.h,v 1.22 2003/04/01 10:29:08 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// ------------------------------------------------------------------------- //

#ifndef _IMAGE_H_
#define _IMAGE_H_

#if HAVE_CONFIG_H
# include <config.h>
#endif

#ifndef __GNUC__
# ifdef _WIN32
#  include <windows.h>
# endif
#endif

#if HAVE_GL_GL_H
# include <GL/gl.h>
#endif

#if HAVE_OPENGL_GL_H	// Mac OS X
# include <OpenGL/gl.h>
#endif

#include "common.h"

// ------------------------------------------------------------------------- //

// TODO: consider using SDL image loading facilities when possible

//! The Image class implements simple handling of RGBA images

class Image
{
friend class ImageLoader;
public:
	Image(int w, int h, int channels);
	~Image();
	GLubyte *get_buffer() const { return _buf; }
	uint     get_width()  const { return _width; }
	uint     get_height() const { return _height; }
	uint     get_channels() const { return _channels; }
	uint     get_buffer_size() const { return _width * _height * _channels; }
	void     copy_from(Image *img, iv2 dest, Rect src);
	void     scale(int new_width, int new_height);
	void     swap_xy();
	void     scale_horizontal(int new_width);
	void     default_texture();
	void     gray_alpha();
	GLubyte* pixel(int x, int y) {
		assert(y>=0 && (uint)y < _height && x >= 0 && uint(x) < _width);
		return &_buf[_width * y * _channels + x * _channels];
	}
private:
	GLubyte* pixel_in_buf(GLubyte* buf, int w, int h, int c, int x, int y) {
		assert(y>=0 && y < h && x >= 0 && x < w);
		return &buf[w * y * c + x * c];
	}
	GLubyte* new_buf() { return new GLubyte[_width*_height*_channels]; }
	void     del_buf(GLubyte *buf) { delete [] buf; }
	void     replace_buf(GLubyte *buf, int w, int h, int c) {
		_buf = buf; _width = w; _height = h; _channels = c;
	}
	GLubyte *_buf;
	uint     _width, _height;
	uint     _channels;
};

//! ImageLoader produces Images from PNG files

class ImageLoader
{
public:
	ImageLoader();
	~ImageLoader();
	Image *load(const char *filename);
};

class ImageSaver
{
public:
	ImageSaver();
	~ImageSaver();
	bool save(Image *image, const char *filename);
};


#endif	// _IMAGE_H_ 

// ------------------------------------------------------------------------- //

