/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *  Loic Dachary <loic@gnu.org>
 *
 */

#ifndef _pokerbubble_h
#define _pokerbubble_h

#include <ugame/artefact.h>
#include <ugame/text.h>
#include <string>

#include <maf/interpolator.h>

class PokerApplication;

namespace osg { class PositionAttitudeTransform; }

class PokerBubbleModel : public UGAMEArtefactModel
{
 public:
  PokerBubbleModel(PokerApplication* game);
  virtual ~PokerBubbleModel();
  virtual void Init();
  void SetTextMessage(const std::string &msg);
  void Update(float delta);

 private:
  enum State
    {
      GROW,
      SHOW,
      SHRINK,
      NONE
    };
  void AddTimeAndScale(float delta);
  void SetInterpolator(const osg::Vec3 &from, const osg::Vec3 &to, float timeout);
  osg::Vec3 mCurrentScale;
  osg::Vec3 mMinScale;
  osg::Vec3 mMaxScale;
  float mShrinkTimeout;
  float mGrowTimeout;
  float mShowTimeout;
  State mState;
  float mTimeout;

  float	mBubbleWidth;
  float	mBubbleHeight;

  osg::ref_ptr<UGAMEFramedText>	mText;
  osg::ref_ptr<osg::PositionAttitudeTransform>	mPAT;
  std::string	mDisplayedText;

  MAFPowInterpolator<osg::Vec3, 3> mInterpolator;
  MAFInterpolatorTimer<> mTimer;
};

class PokerBubbleController : public UGAMEArtefactController
{
 public:
  PokerBubbleController(PokerApplication* game);
  virtual ~PokerBubbleController();

  PokerBubbleModel* GetModel() { return dynamic_cast<PokerBubbleModel*>(UGAMEArtefactController::GetModel()); }

  void SetTextMessage(const std::string &msg);
  bool Update(MAFApplication* application);
};

#endif
