/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Henry Prcheur <henry@precheur.org>
 *
 */

#include "pokerStdAfx.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#endif

#include <maf/maferror.h>
#include <maf/packets.h>

#ifndef WIN32
#	include "PokerError.h"
#	include "PokerApplication.h"
#	include "PokerInteractor.h"
#endif // WIN32


PokerInteractor::PokerInteractor() : mClickStatus(false),
					       mStealedCamera(false),
					       mWasClickedFocused(false),
					       mDelta(0),
					       mDirtyDisplay(false)
{
}

bool PokerInteractor::Update(MAFApplication *application)
{
  SDL_Event* event = application->GetLastEvent(this);

  bool clickStatus = mClickStatus;
  //  bool stealedCamera = mStealedCamera;

  bool focused = (application->GetFocus() == this);
  bool clickEvent = false;

  if (event)
    {
      if(event->type == SDL_MOUSEBUTTONDOWN && event->button.button == SDL_BUTTON_LEFT)
 	{
	  clickStatus = true;
	  clickEvent = true;
	  if (focused)
	    GrabCamera(application, true);
	    //	    application->LockMouse(this);
 	}
      else if (event->type == SDL_MOUSEBUTTONUP && event->button.button == SDL_BUTTON_LEFT)
	{
	  clickStatus = false;
	  clickEvent = true;
	  if (mWasClickedFocused)
	    GrabCamera(application, false);
	  if (!focused)
	      mWasClickedFocused = false;
	  // 	  application->UnlockMouse(this);
	}
    }
  

  bool clickAndFocused = clickStatus && clickEvent && focused;
  bool selected =  (!clickStatus && clickEvent && focused && mWasClickedFocused && GetSelectable());
  if (mDirtyDisplay || clickEvent)
    {
      for (unsigned int i = 0; i < mNodes2Clear.size(); i++)
	mNodes[mNodes2Clear[i]]->setNodeMask(0);
      mNodes2Clear.clear();
      UpdateDisplay(clickAndFocused || mWasClickedFocused || selected);
      mDirtyDisplay = false;
    }
  
  if (clickEvent)
    {
      if (selected)
	SetSelected(true);
      
      mClickStatus = clickStatus;
      mWasClickedFocused = clickAndFocused;
    }
      
  return true;
}

void PokerInteractor::UpdateDisplay(bool clickAndFocused)
{
  if (clickAndFocused)
    {
      if (GetNodeDisplayed("default") != !clickAndFocused)
	SetNodeDisplayed("default", !clickAndFocused);
      if (GetNodeDisplayed("clicked") != clickAndFocused)
	SetNodeDisplayed("clicked", clickAndFocused);
    }
  else

    {
      if (GetNodeDisplayed("clicked") != clickAndFocused)
	SetNodeDisplayed("clicked", clickAndFocused);
      if (GetNodeDisplayed("default") != !clickAndFocused)
	SetNodeDisplayed("default", !clickAndFocused);
    }
}

void PokerInteractor::Init(PokerApplication* game, MAFOSGData* seatData, const std::string &urlPrefix)
{
  UGAMEArtefactController::Init();

  const std::list<std::string> &nodesUrl = game->HeaderGetList("sequence", urlPrefix + "/nodes/node/@url");
  std::list<std::string>::const_iterator begin = nodesUrl.begin();
  std::list<std::string>::const_iterator end = nodesUrl.end();
  while(begin != end)
    {
      const std::string &nodeUrl = *begin;
      InitNode(game, nodeUrl);
      begin++;
    }

  const std::string &anchorName = game->HeaderGet("sequence", urlPrefix + "/@anchor"); 
  MAFAnchor* anchorNode = seatData->GetAnchor(anchorName);
  g_assert(anchorNode != 0);
  Anchor(anchorNode);
  game->AddController(this);
  SetSelectable(true);
}

void PokerInteractor::Finit(PokerApplication *game)
{
  game->RemoveController(this);
  RecursiveClearUserData(GetModel()->GetNode());
}

void PokerInteractor::InitNode(PokerApplication* game, const std::string &nodeUrl)
{
  osg::Node *node = static_cast<MAFOSGData*>(game->mDatas->GetVision(nodeUrl))->GetGroup();
  g_assert(node != 0);
  node->setNodeMask(0);
  osg::PositionAttitudeTransform *pat = new osg::PositionAttitudeTransform;
  pat->setPosition(osg::Vec3(0.0f, mDelta, 0.0f));
  pat->addChild(node);
  GetModel()->GetPAT()->addChild(pat);
  mNodes[nodeUrl] = node;
}

void PokerInteractor::Accept(MAFPacket *packet)
{
  std::string state;
  std::string node;
  packet->GetMember("state", state);
  packet->GetMember("node", node);
  typedef std::map<std::string, std::string >::iterator It;  
  
  It nameIt = mState2Name.find(state);
  
  bool nameFound = (nameIt != mState2Name.end());
  if (nameFound)
    {
      if ((*nameIt).second != node)
	{  
	  const std::string &nodeName = (*nameIt).second;
	  if (nodeName != "")
	    mNodes2Clear.push_back(nodeName);
	  //SetNodeDisplayed(state, false);
	}
    }

  bool nodeDisabled = (node == "");
  if (nodeDisabled)
    {
      SetSelectable(false);
      //mNodes2Clear.push_back(mState2Name[state]);
      //SetNodeDisplayed(state, false);
    }
  else if (!GetSelectable())
    SetSelectable(true);

  mState2Name[state] = node;
  mDirtyDisplay = true;
}

void PokerInteractor::SetNodeDisplayed(const std::string &state, bool displayed)
{
  const std::string &name = mState2Name[state];
  if (name == "")
    return;
  g_assert(mNodes.find(name) != mNodes.end());
  mNodes[name]->setNodeMask(displayed ? 0xffffffff : 0);
}

bool PokerInteractor::GetNodeDisplayed(const std::string &state)
{
  const std::string &name = mState2Name[state];
  if (name == "")
    return false;
  g_assert(mNodes.find(name) != mNodes.end());
  return (mNodes[name]->getNodeMask() == 0xffffffff);
}

void PokerInteractor::GrabCamera(MAFApplication *application, bool status)
{
  if (mStealedCamera != status)
    {
      PokerApplication *game = static_cast<PokerApplication *>(application);
      PokerCameraController* camera = static_cast<PokerCameraController*>(game->GetScene()->GetModel()->mCamera.get());  
      mStealedCamera = status;
      camera->SetRespondToEvents(!status);
    }
}
