/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */

#ifndef _poker_move_chips_h
#define _poker_move_chips_h

#include <maf/controller.h>
#include <osg/Vec3>
#include <osg/ref_ptr>
#include <osg/MatrixTransform>
#include <maf/interpolator.h>
#include <maf/data.h>
#include <PokerChipsStack.h>

class PokerApplication;


class PokerMoveChipsBase : public MAFController
{
  osg::ref_ptr<PokerChipsStackController> mTargetChips;


public:  
  PokerMoveChipsBase(PokerApplication* game);
  virtual ~PokerMoveChipsBase();

  osg::ref_ptr<PokerChipsStackController> mChips;
  osg::ref_ptr<osg::MatrixTransform> mTransform;
  float mTimeDuration;

  void SetTargetChipsStack(PokerChipsStackController* chipstack) { mTargetChips=chipstack;}
  void UpdateTarget();
  void Display(bool state);
  bool IsFinished();
  bool mFinished;

  float GetDuration() { return mTimeDuration;}
};




class PokerMoveChipsBet2PotController : public PokerMoveChipsBase
{
 public:
  PokerMoveChipsBet2PotController(PokerApplication* game,osg::Node* source);
  ~PokerMoveChipsBet2PotController();

  float mAngleToInterpolate;
  osg::Matrix mBaseMatrix;
  float mDistanceFromCenter;
  float mDistanceToInterpolate;
  float mTimeToOffset;

  void StartAnimation();
  void InitAnimation();


  /// general data
  bool Update(MAFApplication* application);

  float mInternalTimer;
  osg::ref_ptr<osg::Node> mNode;
  /// end general

};

class PokerMoveChipsPot2PlayerController : public PokerMoveChipsBet2PotController
{
 public:
  PokerMoveChipsPot2PlayerController(PokerApplication* game,osg::Node* source):PokerMoveChipsBet2PotController(game,source){}
  ~PokerMoveChipsPot2PlayerController();

  bool Update(MAFApplication* application);
  void InitAnimation();
};


#endif

