/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#ifndef _pokershowdown_h
#define _pokershowdown_h

#include <vector>

#include <ugame/artefact.h>

#include <osg/Group>

class PokerShowdownModel : public UGAMEArtefactModel {
public:
  PokerShowdownModel(PokerApplication* game, MAFOSGData* data);
  virtual ~PokerShowdownModel();

  virtual void Init(void);

  struct CardsGroup {
    std::vector<osg::ref_ptr<PokerCardController> > mCards;
    osg::ref_ptr<osg::Node> mGlow;
    osg::Vec4 mColor;
  };

  enum Side { 
    HIGH = 0,
    LOW = 1,
    CARDS_SIZE = 2
  };

  PokerApplication* mGame;
  int mSetCount;
  osg::ref_ptr<osgText::Text> mHandValue;
  osg::Vec4 mColors[CARDS_SIZE];
  CardsGroup mCardsGroup[CARDS_SIZE];
  osg::Vec4 mShowdownCardColor;
};

class PokerShowdownController : public UGAMEArtefactController {
public:
  typedef PokerShowdownModel::CardsGroup CardsGroup;

  PokerShowdownController(PokerApplication* game, MAFOSGData* data);
  virtual ~PokerShowdownController();

  PokerShowdownModel* GetModel() { return dynamic_cast<PokerShowdownModel*>(UGAMEArtefactController::GetModel()); }

  virtual bool Update(MAFApplication* application);

  void Set(const std::string& side, std::vector<int> values, std::vector<int> board, const std::string& handval);
  void Reset(void);

private:
  void SetColor(osg::Node* node, const osg::Vec4& color);
  void UnsetColor(osg::Node* node);
};

#endif // _pokershowdown_h
