#
# Copyright (C) 2004 Mekensleep
#
# Mekensleep
# 24 rue vieille du temple
# 75004 Paris
#       licensing@mekensleep.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# Authors:
#  Loic Dachary <loic@gnu.org>
#  Henry Precheur <henry@precheur.org>
#

from re import match
from twisted.python import dispatch
from twisted.internet import reactor
import twibber.client
from twibber import xmppstream
from poker.jabberproxy import JabberProxyClient, JabberProxyClientFactory, JabberProxyServer, JabberProxyServerFactory

JABBER_MESSAGE = "//event/poker3d/pokerjabber/message"

class PokerJabberProxyClient(JabberProxyClient):

    def elementReceived(self, tag):
        JabberProxyClient.elementReceived(self, tag)
        if self.factory.verbose > 3:
            print "jabber element: %s" % tag.tagName
        if ( tag.tagName == "message" and
             tag.getAttribute("type") == "groupchat" and
             tag.getElementsByTagName("body") ):
            body = tag.getElementsByTagName("body")[0]
            if ( body.hasChildNodes() and
                 hasattr(body.childNodes[0], "data") ):
                message = body.childNodes[0].data.encode('UTF-8')
                if self.factory.verbose > 3:
                    print "elementReceived: %s" % tag.getAttribute("from").encode('UTF-8')
                matched = match("([\w-]+)@.*/([\w-]+)", tag.getAttribute("from"))
                if matched:
                    (chat, author) = matched.groups()
                    self.peer.factory.publishEvent(JABBER_MESSAGE, chat, author, message)
                else:
                    if self.factory.verbose > 3:
                        print "no match"

class PokerJabberProxyClientFactory(JabberProxyClientFactory):

    protocol = PokerJabberProxyClient

    def __init__(self, *args, **kwargs):
        JabberProxyClientFactory.__init__(self, *args, **kwargs)

class PokerJabberProxyServer(JabberProxyServer):

    clientProtocolFactory = PokerJabberProxyClientFactory

class PokerJabberProxyServerFactory(JabberProxyServerFactory):

    protocol = PokerJabberProxyServer

    def __init__(self, *args, **kwargs):
        JabberProxyServerFactory.__init__(self, *args, **kwargs)

JABBER_AUTHORCREATE_OK = "//event/poker3d/pokerjabber/authorcreate/ok"
JABBER_AUTHORCREATE_FAILED = "//event/poker3d/pokerjabber/authorcreate/failed"

class PokerJabberAuthOrCreate(dispatch.EventDispatcher):

    def __init__(self, host, port, name, password, verbose):
        dispatch.EventDispatcher.__init__(self)
        self.host = host
        self.port = port
        self.name = name
        self.password = password
        self.verbose = verbose
        self.state = "starting"

        from twibber import xmppstream
        if self.verbose > 3:
            xmppstream.debug = self.verbose
        else:
            xmppstream.debug = 0

        from twibber import xmlstream
        if self.verbose > 3:
            xmlstream.debug = self.verbose
        else:
            xmlstream.debug = 0
        
    def jabberCreateAccount(self, jabber):
        jabber.closeStream()
        
        if self.verbose:
            print "jabberCreateAccount: %s => %s:%d" % ( self.name, self.host, self.port )
        factory = twibber.client.XMPPClientFactory(self.host,
                                                   self.name,
                                                   self.password,
                                                   auth = 'inband registration')
        factory.listenEvent(xmppstream.JC_CONNECTION_FAILED, self.jabberCannotConnect)
        factory.listenEvent(twibber.client.JC_REGISTRATION_SUCCESS, self.jabberAuth)
        factory.listenEvent(twibber.client.JC_REGISTRATION_ERROR, self.jabberCannotAuth)
        reactor.connectTCP(self.host, self.port, factory, 20000)
        self.state = "register"

    def jabberCannotAuth(self, jabber, error = 'Unknown'):
        print "Failed to authenticate %s to jabber server %s:%d" % ( self.name, self.host, self.port )
        print """
It may be because the login name does not fit the
constraints of jabber or because the login is already taken
by someone else or because the password is invalid.
"""
        print "Jabber disabled"
        self.publishEvent(JABBER_AUTHORCREATE_FAILED)
        del self.callbacks

    def jabberCannotConnect(self, jabber, reason):
        print "Unable to connect to jabber host %s:%d : %s" % ( self.host, self.port, reason )
        print "Jabber disabled"
        self.publishEvent(JABBER_AUTHORCREATE_FAILED)
        del self.callbacks
        
    def jabberAuth(self, jabber = None):
        if jabber:
            jabber.closeStream()
            
        if self.verbose:
            print "jabberAuth: %s => %s:%d" % ( self.name, self.host, self.port )
        factory = twibber.client.XMPPClientFactory(self.host, self.name, self.password)
        factory.listenEvent(xmppstream.JC_CONNECTION_FAILED, self.jabberCannotConnect)
        factory.listenEvent(twibber.client.JC_AUTH_SUCCESS, self.jabberAuthSuccess)
        if self.state == "starting":
            factory.listenEvent(twibber.client.JC_AUTH_ERROR, self.jabberCreateAccount)
        elif self.state == "register":
            factory.listenEvent(twibber.client.JC_AUTH_ERROR, self.jabberCannotAuth)
        else:
            print "jabberAuth: unexpected state %d" % self.state
        reactor.connectTCP(self.host, self.port, factory, 20000)
        self.state = "auth"

    def jabberAuthSuccess(self, jabber):
        self.publishEvent(JABBER_AUTHORCREATE_OK, jabber)
        del self.callbacks
