#
# Copyright (C) 2004 Mekensleep
#
# Mekensleep
# 24 rue vieille du temple
# 75004 Paris
#       licensing@mekensleep.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# Authors:
#  Loic Dachary <loic@gnu.org>
#
import sys
sys.path.insert(0, "..")
sys.path.insert(0, "../../python")

from twisted.internet import reactor, error

from underware.client import UGAMEClientProtocol, UGAMEClientFactory
from underware.config import Config
from poker.pokerpackets import *

class PokerStatsClient(UGAMEClientProtocol):
    """Poker client"""

    def __init__(self):
        UGAMEClientProtocol.__init__(self)
        
    def _handleConnection(self, packet):
        if packet.type == PACKET_SERIAL:
            self.user.serial = packet.serial
            return
        
        elif packet.type == PACKET_POKER_TABLE_LIST:
            tables_playing = filter(lambda table: table.players > 1, packet.packets)
            if len(tables_playing) > 0:
                hands_per_hour = sum(map(lambda table: table.hands_per_hour, tables_playing)) / len(tables_playing)
                print "Hands per hour: %d" % hands_per_hour
                print "%d players" % sum(map(lambda table: table.players, packet.packets))
            else:
                print "No players"
            print "%d tables (%d playing, %d empty)" % ( len(packet.packets), len(tables_playing), len(packet.packets) - len(tables_playing))
            self.transport.loseConnection()

    def protocolEstablished(self):
        self.sendPacket(PacketPokerTableSelect())

    def connectionLost(self, reason):
        reactor.stop()

class PokerStatsFactory(UGAMEClientFactory):

    def __init__(self, *args, **kwargs):
        UGAMEClientFactory.__init__(self, *args, **kwargs)
        config = kwargs["config"]
        self.config = config
        self.verbose = config.headerGetInt("/stats/@verbose")
        self.protocol = PokerStatsClient
        
    def clientConnectionFailed(self, connector, reason):
        print "Failed to establish connection"
        print reason
        reactor.stop()
        
    def clientConnectionLost(self, connector, reason):
        if not reason.check(error.ConnectionDone):
            print reason
        reactor.stop()

def run(argv):
    path = len(argv) > 0 and argv[0] or "file:poker.stats.xml"

    config = Config([''])
    config.loadHeader(path)

    host = config.headerGet("/stats/host")
    port = config.headerGetInt("/stats/port")

    print "Statistics for %s:%d" % ( host, port )
    reactor.connectTCP(host, port, PokerStatsFactory(config = config))

    reactor.run()
    config.release()

if __name__ == '__main__':
    run(sys.argv[1:])

