from xmlutils import * 
from elements import Iq

ns_disco_info='http://jabber.org/protocol/disco#info'
ns_disco_items='http://jabber.org/protocol/disco#items'

# This class is an example of mixin usage for specialized <iq> handlers

class DiscoMixIn:
    
    def __init__(self, feature_handlers={}, identities=[]):#, item_handlers={}):
        """ """
        self.setIqHandler(ns_disco_info, 'query', self.gotDiscoInfoRequest)
        self.setIqHandler(ns_disco_items, 'query', self.gotDiscoItemsRequest)
        self._disco_features=feature_handlers
        self._disco_identities=identities
        #self._disco_items=feaure_items
    
    def registerFeature(self, feature, handler):
        self._disco_features[feature]=handler
    
    def getFeatureHandler(self, feature):
        return self._disco_features.get(feature, None)
    
    def hasFeature(self, feature):
        return self._disco_features.has_key(feature)
    
    def setIdentity(self, category, type, name):
        self._disco_identites.append((category, type, name))
    
    def gotDiscoInfoRequest(self, iq):
        """ Got a disco request of info """
        answer=iq.makeResultFrom()
        query=ezel(answer.setQueryNS(ns_disco_info))
        for cat,type,name in self._disco_identities:
            id=query.add('identity', cat=cat, type=type)
            if name: id['name']=name #name is optional
        for f,h in self._disco_features.items():
            query.add('feature', var=f)
        self.sendIq(answer)
        
    def gotDiscoItemsRequest(self, iq):
        """ Got disco request of items """

    def sendDiscoInfoRequest(self, to):
        """ """
        iq=Iq(to=to, ttype='get')
        iq.setQueryNS(ns_dico_info)
        d=self.sendIq(iq)
        d.addCallback(self.gotDiscoInfoAnswer)
        d.addErrback(self.gotDiscoInfoError)
        return d
        
    def sendDiscoItemsRequest(self, to):
        """ """
        iq=Iq(to=to, ttype='get')
        iq.setQueryNS(ns_dico_items)
        d=self.sendIq(iq)
        d.addCallback(self.gotDiscoItemsAnswer)
        d.addErrback(self.gotDiscoItemsError)
        return d
    
    def gotDiscoInfoAnswer(self, iq):
        """ Got the answer for disco info """
        return iq
        
    def gotDiscoInfoError(self, iq):
        """ Got an error answer for disco info """
        return iq
        
    def gotDiscoItemsAnswer(self, iq):
        """ Got the answer for disco items """
        return iq
    
    def gotDiscoItemsError(self, iq):
        """ Got the answer for disco items """
        return iq
