#class PresenceItem:
#    
#    def __init__(self, presence=None, ttype='', show='', status='', **kw):
#        if presence is None:
#            self.show=show
#            self.status=status
#            self.type=ttype
#        else:
#            self.show=show
#            self.status=status
#            self.type=ttype
#        
#        for k,w in kw.items():
#            setattr(self, k, w)

#XXX Pay attention to the jid logged in with different resources. What does it happen?
from elements import Iq, Presence

class Roster:
    
    def __init__(self):
        self._groups={}
        self._contacts={}
    
    def addContact(self, jid, name='', group='', subscription='both'):
        """ add a contact """
        jid=str(jid)
        t=(jid, name, group, subscription)
        self._groups.setdefault(group, []).append(jid)
        self._contacts[jid]={'group':name, 'group':group, 'subscription':subscription, 'presence':Presence(ttype='unavailable')}
        

    def removeContact(self, jid):
        """ remove a contact """
        jid=str(jid)
        g=self._contacts[jid][1]
        self._groups[g].remove(jid)
        del self._contacts[jid]
    
    def setPresence(self, jid, presence):
        """ store presence information """
        jid=str(jid)
        if self._contacts.has_key(jid):
            self._contacts[jid]['presence']=presence

    def getPresence(self, jid):
        """ get last known presence information """
        jid=str(jid)
        if self._contacts.has_key(jid):
            return self._contacts[jid].get('presence')
        
    def hasContact(self, jid):
        """ Check whether the jid is in the contacts """
        jid=str(jid)
        return self._contacts.has_key(jid)

class RosterMixIn:
    """ MixIn class for adding roster capabilities """
    
    def __init__(self):
        self._roster=Roster()
        
    def handlePresence(self, tag):
        """ Handle <presence/> stanzas """
        presence=Presence(element=tag)
        type=presence.getType()
        if type=='subscribe':
            self.gotSubscribe(presence.getFrom())
        elif type=='subscribed':
            self.gotSubscribed(presence.getFrom())
        elif type=='unsubscribe':
            self.gotUnsubscribe(presence.getFrom())
        elif type=='unsubscribed':
            self.gotUnsubscribed(presence.getFrom())
        else:
            jid=presence.getFrom().getStripped()
            self.presenceChanged(presence)
            self._roster.setPresence(jid, presence)
            self.gotPresence(presence)

    def gotPresence(self, presence):
        """ Called when we get a presence element (after the update of 
        the roster) """
    
    def presenceChanged(self, presence):
        """ Called when we get a presence element, before updating the 
        roster """
    
    def getRoster(self):
        """ send a roster iq """
        iq=Iq(ttype='get')
        iq.setQueryNS('jabber:iq:roster')
        d=self.sendIq(iq)
        d.addCallback(self.gotRoster)
        d.addErrback(self.gotRosterError)

    def gotRoster(self, iq):
        """ got a roster result """
        if iq.getType()=='result':
            q=iq.getQueryNode()
            for c in q.getElementsByTagName('item'):
                jid=c.getAttribute('jid')
                name=c.getAttribute('name')
                subscription=c.getAttribute('subscription')
                g=get_child(c,'group')
                if g: group=get_text(g)
                else: group=''
                self._roster.addContact(jid, name, group, subscription)
    
    def gotRosterError(self, iq):
        """ got a roster error """
        pass

    def removeRosterItem(self, jid):
        """ shortcut to remove subscriptions """
        iq=Iq(ttype='set')
        q=iq.setQueryNS('jabber:iq:roster')
        e=ezel('item')
        e['jid']=str(jid)
        e['subscription']='remove'
        q.appendChild(e.dom())
        self.sendIq(iq)
        
    def gotSubscribed(self, ffrom):
        """ ovverride """
    
    def gotSubscribe(self, ffrom):
        """ override if you don't want authomatic accepts """
        #Authomatically accept subscriptions
        self.subscribed(ffrom)
        self.subscribe(ffrom) #XXX is this correct?
        
    def gotUnsubscribe(self, ffrom):
        """ override if you don't want to reciprocal """ 
        self.unsubscribe(ffrom)

    def gotUnsubscribed(self, ffrom):
        """ """
        pass

    def subscribe(self, jid, group=None, name=None):
        """ Subscribe to another jid in group 'group' """
        kw={'jid':jid}
        r_el=roster_item(str(jid), group=name, name=name)
        iq=Iq(ttype='set')
        iq.setQueryNS('jabber:iq:roster').appendChild(r_el)
        self.sendStanza(iq)
        p=Presence(to=jid, ttype='subscribe')
        self.sendStanza(p)
        
    def subscribed(self, jid, group=None, name=None):
        """ set subscribed for another jid in group 'group' """
        kw={'jid':jid}
        r_el=roster_item(str(jid), group=name, name=name)
        iq=Iq(ttype='set')
        iq.setQueryNS('jabber:iq:roster').appendChild(r_el)
        self.sendStanza(iq)
        p=Presence(to=jid, ttype='subscribed')
        self.sendStanza(p)
        
    def unsubscribe(self, jid):
        """ """
        #XXX this seems not work with jabberd 1.4x
        #use removeRosterItem()
        p=Presence(to=jid, ttype='unsubscribe')
        self.sendStanza(p)
    
    def unsubscribed(self, jid):
        """ """
        p=Presence(to=jid, ttype='unsubscribed')
        self.sendStanza(p)
