/**
   Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   ****************************************************************************
   * @file   exg_scene.h
   *
   * @brief   base for scene exchange
   *
   *****************************************************************************
   *
   * @author  Cedric Pinson
   *
   * @date    Created 2001/04
   *
   * @version $Id: exg_scene.h,v 1.2 2004/04/27 18:11:18 loic Exp $
   *
   ****************************************************************************/


#ifndef exg_scene_h
#define exg_scene_h

#include <string>
#include <exg/exg_basetypes.h>

namespace exg
{
  
  class Visitor;

  class EXG_EXPORT Scene : public NodeGroup
  {



   public:
    COMMON_FUNCTIONS(Scene)

    /// Default constructor
    Scene() {
      (*this)["name"]=new File;
    }


    /// Set name of mesh
    void SetName(const std::string& name) { 
      File* s=(File*)(*this)["name"].Get();
      s->SetName(name);
    }



    const std::string& GetName() const {
      File* s=(File*)(*find("name")).second.Get();
      return s->GetName();
    }


    void Traverse(Visitor& visitor);

    Scene* AsScene(void) { return this; }
    const Scene* AsScene(void) const { return this; }
    int GetType() const { return SCENE; }
    inline static Object* Create() { return new Scene; }

    std::ostream& operator<<(std::ostream& o);

  };

}

#endif         
