/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */

#ifndef maf_audio_h 
#define maf_audio_h

#ifndef MAF_USE_VS_PCH
#include <osg/Node>
#include <osgAL/SoundNode>
#include <osgAL/SoundState>
#endif

#include <maf/data.h>
#include <maf/model.h>
#include <maf/view.h>
#include <maf/controller.h>

class MAF_EXPORT MAFAudioModel : public MAFModel
{
public:
  MAFAudioModel();
  virtual ~MAFAudioModel();

  void SetData(MAFAudioData* data) { mData = data; }

  const std::string& GetName();
  void SetName(const std::string& name);


  ALfloat GetGain();
  void SetGain(ALfloat gain);

  osg::Vec3 GetPosition();
  void SetPosition(const osg::Vec3& position );

  bool GetPlaying();
  void SetPlaying( bool playing );

  void SetPriority(int pri);
  int GetPriority();

  osg::Node* GetNode() { return mNode.get();}

  void SetStatePlaying(bool b);

  void SetStopMethod(openalpp::SourceState stop);

  bool PlayEvent(int priority=-1);

  osgAL::SoundState* GetState() { return mSoundState.get();}
  void SetReferenceDistance(float d);

  void SetRolloff(float d);
  float GetRolloff();
  float GetReferenceDistance();

  void SetAmbient(bool a);
  osg::Vec3 GetDirection();
  osg::Vec3 GetVelocity();
  bool GetRelative();
  void DumpState();


  void Init();
  
  static void CheckError(const std::string& message);

protected:
  MAFAudioData* mData;
  int mPriority;
  std::string mName;
  osg::ref_ptr<osgAL::SoundState> mSoundState;
  osg::ref_ptr<osgAL::SoundNode> mNode;
};


typedef MAFView MAFAudioView;

class MAFSceneController;

class MAF_EXPORT MAFAudioController : public MAFController
{
public:
  MAFAudioController() {}
  virtual ~MAFAudioController() {}

  MAFAudioModel* GetModel() { return dynamic_cast<MAFAudioModel*>(MAFController::GetModel()); }
  MAFAudioView* GetView() { return dynamic_cast<MAFAudioView*>(MAFController::GetView()); }

  virtual void Init( void );

  void BindToScene(MAFSceneController* scene);
  void MoveTo( osg::Vec3 position );
  void AttachTo( osg::Group* group );
  void Play( void );
  void PlayEvent( void );
  void Stop( void );
};


#endif // maf_audio_h
