/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *  Henry Precheur <henry@precheur.org>
 *
 */
/*
 *
 * Copyright (C) Nicolas Roussel
 * Copyright (C) 2003 Olivier Chapuis
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * Note: LICENSE is LGPL
 *
 */


#ifndef _XwncWindow_H
#define _XwncWindow_H

#ifndef MAF_USE_VS_PCH

#include <string>

#include <osg/Group>
#include <osg/Texture2D>
#include <osg/Array>
#include <osg/Geometry>
#include <osg/Geode>
#include <osg/MatrixTransform>
#endif

class wncSource;
class WncImage;

#define USE_NEW_WNC_WINDOW

#ifdef USE_NEW_WNC_WINDOW
class XwncRegionWindow;
#endif

class TextureSubloadCallback: public osg::Texture2D::SubloadCallback
{
public:
  struct SubImage
  {
#ifdef USE_NEW_WNC_WINDOW
    SubImage(osg::Image* image, int x, int y,XwncRegionWindow* region = 0, bool is_complete_texture = false);
#else
    SubImage(osg::Image* image, int x, int y, bool is_complete_texture = false);
#endif
    ~SubImage();

    osg::ref_ptr<osg::Image> mImage;
    int	mX, mY;
#ifdef USE_NEW_WNC_WINDOW
    XwncRegionWindow* mRegion;
#endif
    bool	mIsCompleteTexture;
  };

  TextureSubloadCallback(unsigned long id, std::vector<SubImage*>* images);
  TextureSubloadCallback(std::vector<SubImage*>* images);
  virtual void load(const osg::Texture2D& texture, osg::State&) const;
  virtual void subload(const osg::Texture2D& texture, osg::State&) const;

protected:
  std::vector<SubImage*>*	mImages;
  unsigned long	_frameID;
};


#ifdef USE_NEW_WNC_WINDOW

class XwncRegionWindow
{
  osg::ref_ptr<osg::Texture2D>	mTexture;
  osg::ref_ptr<osg::Geometry>	mGeom;
  osg::ref_ptr<TextureSubloadCallback> mCallback;
  std::vector<TextureSubloadCallback::SubImage*> mImages;

public:

  XwncRegionWindow() {}
  ~XwncRegionWindow();
  void Init(int x,int y,int width,int height,int textureSizeX,int textureSizeY,int yGL,const osg::Vec4& color);

  osg::Geometry* GetGeometry() { return mGeom.get(); }
  
  void UpdateFromImage(osg::Image*,int x, int y ,int width,  int height);

  void DecreaseX(int newsize);
  void DecreaseY(int newsize);


  void Hide(bool hide=true);

  int mTextureSizeX;
  int mTextureSizeY;
  int mPosX;
  int mPosY;
  int mSizeX;
  int mSizeY;

};


class XwncGenericWindow : public osg::Geode
{
  typedef std::vector<XwncRegionWindow*> RowXwncRegionWindow;
  std::vector<RowXwncRegionWindow> mCols; // contains cols*row

  RowXwncRegionWindow BuildRow(int starty,
			       int width, 
			       int height,
			       int textureSizeY,
			       int yGL,
			       const osg::Vec4& color);


public:
  XwncGenericWindow() {}
protected:
  virtual ~XwncGenericWindow();
public:
  void DispatchImageUpdate(osg::Image* _sub_image, int x, int y,int w, int h);
  void Init(int width, int height);
  void ResizeWindowSmaller(int width,int height);
  void GetTextureSize(int& width,int& height);
  void Kill();

};


#endif


class XwncWindow : public osg::MatrixTransform
{
public:
  enum State
    {
      NONE = 0,
      SLIDE = 1
    };

private:

  std::string _title;
  wncSource*	mWncServer;

#ifdef USE_NEW_WNC_WINDOW
  osg::ref_ptr<XwncGenericWindow> mWindow;
  bool mNotInitialised;
#else

  osg::ref_ptr<osg::Texture2D>	_texture;
  osg::ref_ptr<osg::Geometry>	_geom;
  osg::ref_ptr<osg::Vec3Array>	_vertex;
  osg::ref_ptr<osg::Vec2Array>	_texcoord;
  osg::ref_ptr<TextureSubloadCallback>	_callback;
  std::vector<TextureSubloadCallback::SubImage*>	_images;
#endif
  State	mState;

  bool _resetTexture;

  /*
   * Real position of the window
   * (The one given by Xwnc)
   */
  float _real_x;
  float _real_y;

  /*
   * Display position
   * (The one used by the display)
   */
  osg::Vec2	mDisplayPosition;

  float _width;
  float _height;
  float	_tex_width;
  float	_tex_height;
  unsigned long _frameID;

  bool _mapped;

  float _red, _green, _blue, _alpha ;
  float _alpha_saved;

  bool mIsRootWindow;
  unsigned long _transientFor;
  bool _hide;

  float _layerCorrection;
  float _desktopWidth;
  float _desktopHeight;
  float _eyeDist;

public:

  XwncWindow(std::string title, unsigned long id, wncSource *wncServer,
	     int x, int y, unsigned int width, unsigned int height);

  const std::string& GetTitle() const;
	
  void	configure(int x, int y, int width, int height);
  void getSize(int *width, int *height) const;
  void getSize(float *width, float *height) const;
  void getSize(double *width, double *height) const;

  osg::Geode* GetGeode() { return mWindow.get(); }

  float	GetWidth() const;
  float	GetHeight() const;
  const osg::Vec3f	GetSize() const;

  void getRealPosition(float *x, float *y);
  void getRealPosition(int *x, int *y);

  void getPosition(float *x, float *y, float screen_height);
  void getPosition(int *x, int *y, int screen_height);

  void setMapped(bool mapped);
  bool IsMapped() const;
  bool neverMapped(void);

  void setRootWindow(void);
  bool isRootWindow(void);
  void setEwmhDesktop(void);
  bool isEwmhDesktop(void);
  void setTransientFor(unsigned long w);
  unsigned long  getTransientFor(void);
  void hide(void);

  unsigned long getFrameID(void);

  void setBgcolor(float red, float green, float blue, float alpha);
  void setAlpha(float alpha);
  void setTmpAlpha(float alpha);
  void resetAlpha(void);
  void getBgcolor(float *red, float *green, float *blue, float *alpha);
  float getAlpha(void);

  void resetTexture(void);
  void deleteTexture(void);
  void updateTexture(WncImage *img, int x, int y, unsigned int w, unsigned int h);

  void keyEvent(unsigned long key, bool down_flag);
  void pointerEvent(int x, int y, unsigned char button_mask);

  void Slide(const osg::Vec2& offset);

  osg::MatrixTransform* staticCopy();

protected:
  ~XwncWindow();

  void	setupVertex();
  void	setupTexCoord();
};

#endif // _XwncWindow_H
