/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *  Cedric Pinson <cpinson@freesheep.org>
 *  Igor kravtchenko <igor@obraz.net>
 *
 */

#ifndef ugame_animated_h 
#define ugame_animated_h

#include <vector>

#include <osg/Node>  

#include <osgCal/CoreModel>
#include <osgCal/Model>
#include <ugame/ugameexport.h>

#include <ugame/artefact.h>

#include <maf/data.h>

class MAFCal3dData;
class CalScheduler;

class UGAME_EXPORT UGAMEAnimatedModel : public UGAMEArtefactModel
{
public:
  typedef osgCal::CoreModel::Textures2D Textures2D;
  typedef osgCal::Model::Drawables Drawables;

  UGAMEAnimatedModel();
  virtual ~UGAMEAnimatedModel();

  void Init(void);

  // reinit the animated model with current textures and outfit
  void reinit();

  MAFCal3dData* GetData(void) { return dynamic_cast<MAFCal3dData*>(UGAMEArtefactModel::GetData()); }

  osgCal::Model* GetArtefact(void);

  void SetPrivateTextures(const std::vector<std::string>& privateTextures) { mPrivateTextures = privateTextures; }
  const std::vector<std::string>& GetPrivateTextures(void) { return mPrivateTextures; }
  void SetOutfit(const std::string& outfit) { mOutfit = outfit; }
  const std::string& GetOutfit(void) { return mOutfit; }
  void SetDefaultOutfit(const std::string& defaultOutfit) { mDefaultOutfit = defaultOutfit; }
  const std::string& GetDefaultOutfit(void) { return mDefaultOutfit; }

  CalModel* GetCalModel();
  CalScheduler* GetScheduler();
  CalCoreBone* GetCoreBone(const std::string& name);
  CalBone* GetBone(const std::string& name);
  int GetCoreBoneId(const std::string& name);
  int GetCoreAnimationId(const std::string& name);
  CalCoreAnimation* GetCoreAnimation(int id);
  CalCoreAnimation* GetCoreAnimation(const std::string& name);
  Drawables* GetDrawables(const std::string& name);
  double GetDuration(int id);
  double GetDuration(const std::string& name);

protected:

	void _init();

  osg::ref_ptr<osgCal::Model> mOsgCalModel;

private:
  std::vector<std::string> mPrivateTextures;
  std::string mOutfit;
  std::string mDefaultOutfit;
};

class UGAME_EXPORT UGAMEAnimatedController : public UGAMEArtefactController
{
public:
  typedef osgCal::CoreModel::Textures2D Textures2D;
  typedef osgCal::Model::Drawables Drawables;

  UGAMEAnimatedController() {}
  virtual ~UGAMEAnimatedController() { }

  virtual UGAMEAnimatedModel* GetModel() { return dynamic_cast<UGAMEAnimatedModel*>(UGAMEArtefactController::GetModel()); }

  virtual void Init( void );

  CalModel* GetCalModel() {return GetModel()->GetCalModel();}
  CalScheduler* GetScheduler() {return GetModel()->GetScheduler();}
  CalCoreBone* GetCoreBone(const std::string& name) {return GetModel()->GetCoreBone(name);}
  CalBone* GetBone(const std::string& name) {return GetModel()->GetBone(name);}
  int GetCoreBoneId(const std::string& name) {return GetModel()->GetCoreBoneId(name);}
  int GetCoreAnimationId(const std::string& name) {return GetModel()->GetCoreAnimationId(name);}
  CalCoreAnimation* GetCoreAnimation(int id) {return GetModel()->GetCoreAnimation(id);}
  CalCoreAnimation* GetCoreAnimation(const std::string& name) {return GetModel()->GetCoreAnimation(name);}
  Drawables* GetDrawables(const std::string& name) {return GetModel()->GetDrawables(name);}
  double GetDuration(int id) {return GetModel()->GetDuration(id);}
  double GetDuration(const std::string& name) {return GetModel()->GetDuration(name);}
};

#endif // ugame_animated_h
