/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.org>
 *
 */

#include <windows.h>
#include <tlhelp32.h>
#include <string>
#include <iostream>
#include "killit.h"

bool killit(const char *name)
{
  std::string exeName(name);
  HANDLE hProcessSnap;
  PROCESSENTRY32 pe32;

  hProcessSnap = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
  if(hProcessSnap == INVALID_HANDLE_VALUE)
  {
    std::cerr << "CreateToolhelp32Snapshot (of processes)" << std::endl;
    return false;
  }

  pe32.dwSize = sizeof(PROCESSENTRY32);

  if(!Process32First(hProcessSnap, &pe32))
  {
    std::cerr << "Process32First" << std::endl;
    CloseHandle(hProcessSnap);
    return false;
  }

  do
  {
    std::string processName(pe32.szExeFile);
    if (processName == exeName)
    {
      HANDLE hProcess;
      hProcess = OpenProcess(PROCESS_ALL_ACCESS, FALSE, pe32.th32ProcessID);
      if(hProcess == NULL)
        std::cerr << "OpenProcess" << std::endl;
      else
      {
        std::cout << "TerminateProcess " << processName << ":" << hProcess << std::endl;
        TerminateProcess(hProcess, -1);
        WaitForSingleObject(hProcess, INFINITE);
        CloseHandle(hProcess);
      }
    }
  } while(Process32Next(hProcessSnap, &pe32));

  CloseHandle(hProcessSnap);
  return true;
}