/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.org>
 *
 */

#ifdef _DEBUG // for Windows python23_d.lib is not in distribution... ugly but works
 #undef _DEBUG
 #include <Python.h>
 #define _DEBUG
#else
 #include <Python.h>
#endif
#include "killit.h"

static PyObject*
mywin32_killProcessByName(PyObject* self, PyObject *args)
{
  char *processName = 0;
  if (!PyArg_ParseTuple(args, "s", &processName))
    return NULL;
  
  killit(processName);

  return NULL;
}

static char doc_mywin32_killProcessByName[] =
"Kill Process By Name";

static PyMethodDef win32_killProcessByName_methods[] = {
  { "killProcessByName", (PyCFunction)mywin32_killProcessByName, METH_VARARGS, doc_mywin32_killProcessByName },
  {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC
initpython_mywin32(void)
{
  Py_InitModule("python_mywin32", win32_killProcessByName_methods);
}
