/**
    Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ****************************************************************************
 * @file   exg_vertex.cxx
 *
 * @brief   base for material exchange
 *
 *****************************************************************************
 *
 * @author  Cedric Pinson
 *
 * @date    Created 2001/04
 *
 * @version $Id: exg_vertex.cpp,v 1.1 2004/10/06 15:05:46 izidor79 Exp $
 *
 ****************************************************************************/

#include <exg/exg.h>
#include <exg/exg_vertex.h>
#include <exg/exg_visitor.h>

namespace exg
{
  void Vertex::Traverse(Visitor& visitor) {
    //      std::cout << "Traverse vertex " << this << std::endl; 
    Point* p=GetPoint();
    if (p)
      p->Accept(visitor);
  }

  std::ostream& Vertex::operator<<(std::ostream& o)
  {
    Indent(indent-1,o);
    o << "Vertex\n";
    return MapObjectPointer::operator<<(o);
  }

}
