/**
    Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ****************************************************************************
 * @file   exg_visitor.cxx
 *
 * @brief   base for material exchange
 *
 *****************************************************************************
 *
 * @author  Cedric Pinson
 *
 * @date    Created 2001/04
 *
 * @version $Id: exg_visitor_generate_normal.cpp,v 1.1 2004/10/06 15:05:46 izidor79 Exp $
 *
 ****************************************************************************/

#include <exg/exg.h>
#include <exg/exg_material.h>
#include <exg/exg_visitor_generate_normal.h>
#include <exg/exg_visitor_connectivity.h>

namespace exg
{
  void VisitorGenerateNormalToMaterial::Apply(Material& node)
  {
    node["normal"]=0;
    Traverse(node);
  }


  void VisitorGenerateNormalToMaterial::Apply(Polygon& node)
  {

//    std::cout << "NbPoints " << mConnectivity->mPoints.size() << std::endl;

    ConnectivityPolygon* cpolygon=0;
    cpolygon=(*mConnectivity->mPolygons.find(&node)).second;
    assert(cpolygon && "problem polygon not found in connectivity buffer");
    
    int nbv=node.GetNbVertexes();
    ConnectivityPoint tmpPoint;
    ConnectivityPoint* resultPoint;
    Vector3f* normal=new Vector3f[nbv];
    
//    std::cout << "Polygon part\n";
    for (int j=0;j<nbv;j++) {
      tmpPoint.mPoint=node.GetVertex(j)->GetPoint();
      resultPoint=*(mConnectivity->mPoints.find(&tmpPoint));
      if (!resultPoint) {
        std::cout << node.GetVertex(j)->GetPoint() << std::endl;
        std::cout << tmpPoint.mPoint->GetPosition()[0] << " " 
                  << tmpPoint.mPoint->GetPosition()[1] << " " 
                  << tmpPoint.mPoint->GetPosition()[2] << std::endl;
        assert(resultPoint && "point not found ???");
      }
      
      Vector3f ntmp=ComputeNormalPoint(cpolygon,resultPoint);
      /*VectorFloat* vn=*/(*node.GetVertex(j))["normal"]=new VectorFloat(ntmp);
      
    }
	delete [] normal;
  }


  Vector3f VisitorGenerateNormalToMaterial::ComputeNormalPoint(ConnectivityPolygon* current,ConnectivityPoint* point)
  {
    typedef std::vector<ConnectivityPolygon*> VectorPolygon;
    VectorPolygon list;
    int nbe=point->mEdges.size();
    for (int i=0;i<nbe;i++) {
      int nbp=point->mEdges[i]->mPolygons.size();
      for (int j=0;j<nbp;j++)
        if (IsAngleLessThanSmoothingAngle(current,point->mEdges[i]->mPolygons[j]))
          list.push_back(point->mEdges[i]->mPolygons[j]);
    }
    unique(list.begin(), list.end());

    Vector3f normal(0,0,0);
    for (VectorPolygon::iterator it=list.begin();it!=list.end();it++)
      normal+=(*it)->mRealPolygon->GetPlane().Direction();
      
    normal.Normalize();
    return normal;
  }


  Vector3f VisitorGenerateNormalToMaterial::ComputeNormalEdge(ConnectivityPolygon* current,ConnectivityEdge* edge)
  {
    Vector3f normal(0,0,0);
    int nbp=edge->mPolygons.size();
    for (int i=0;i<nbp;i++)
      if (edge->mPolygons[i]!=current)
        normal+=edge->mPolygons[i]->mRealPolygon->GetPlane().Direction();
    return normal;
  }

}
