/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH

#include <maf/controller.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef WIN32
#include "config_win32.h"
#endif

#include <maf/application.h>
#include <maf/timer.h>

#endif

MAFController::~MAFController() {
  if(GetModel())
    delete GetModel();
  if(GetView())
    delete GetView();
}

void MAFController::Init(void) {
  if(!GetModel())
    SetModel(new MAFModel);
  if(!GetView())
    SetView(new MAFView);

  GetView()->SetModel(mModel);
  GetView()->SetController(this);

  GetModel()->Init();
  GetView()->Init();
}

bool MAFController::DoUpdate(MAFApplication* application) {
  mDeltaFrame=application->GetDeltaFrame();
  double now = GetRealTimeInMS();
  double diff;
  if (mLastUpdate > 0) {
    diff=now - mLastUpdate;
    if (diff<mFrequency)
      return true;
    mDelta = diff;
  }

  mLastUpdate = now;

  return Update(application);
}
