/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */
/*
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * Note: LICENSE is LGPL
 *
 */

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifdef WIN32
#include "config_win32.h"
#endif

#include <maf/wnc_image.h>

#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string>

#endif

#define DEBUG_LEVEL 0

  WncImage::StandardSize WncImage::StandardSizes[] = {	 
    {"16CIF",1408,1152}, // H.263
    {"PAL",768,576},
    {"4CIF",704,576},    // H.263
    {"VGA",640,480},
    {"PAL2",384,288}, // Non-standard name...
    {"CIF",352,288},     // H.263
    {"SIF",320,240},
    {"U1",288,216},      // Non-standard name...
    {"PAL3",256,192}, // Non-standard name...
    {"U2",224,168},      // Non-standard name...
    {"PAL4",192,144}, // Non-standard name...
    {"QCIF",176,144},    // H.263
    {"QSIF",160,120},
    {"SQCIF",128,96},    // H.263
    {0,0,0}
  } ;

  char *
  WncImage::EncodingName(WncImage::Encoding e) {
    switch (e) {
    case WncImage::PREFERRED: return "PREFERRED" ;
    case WncImage::RGB: return "RGB" ;
    case WncImage::ABGR: return "ABGR" ;
    case WncImage::RGBA: return "RGBA" ;
    case WncImage::ARGB: return "ARGB" ;
    case WncImage::L: return "L" ;
    case WncImage::JPEG: return "JPEG" ;
    case WncImage::YpCbCr420: return "YpCbCr420" ;
    default: return "OPAQUE" ;
    }
  }

  WncImage::Encoding
  WncImage::EncodingFromName(const char *name) {
    std::string n = name ;
    if (n=="PREFERRED") return WncImage::PREFERRED ;
    if (n=="ABGR") return WncImage::ABGR ;
    if (n=="RGBA") return WncImage::RGBA ;
    if (n=="ARGB") return WncImage::ARGB ;
    if (n=="L") return WncImage::L ;
    if (n=="JPEG") return WncImage::JPEG ;
    if (n=="YpCbCr420") return WncImage::YpCbCr420 ;
    return WncImage::OPAQUE ;
  }

  float
  WncImage::BytesPerPixel(WncImage::Encoding e) {
    switch (e) {
    case WncImage::L: return 1 ;
    case WncImage::YpCbCr420: return 1.5 ; // Warning: this is a planar format...
    case WncImage::RGB: return 3 ;
    case WncImage::ABGR: return 4 ;
    case WncImage::RGBA: return 4 ;
    case WncImage::ARGB: return 4 ;
    default: return 0 ;
    }
  }

  unsigned int
  WncImage::BytesPerImage(unsigned int w, unsigned int h, WncImage::Encoding e) {
    return (unsigned int)(ceil(w*h*BytesPerPixel(e))) ;
  }

  bool
  WncImage::pixelIsContiguous(Encoding e) {
    switch (e) {
    case WncImage::L: 
    case WncImage::RGB:
    case WncImage::ABGR:
    case WncImage::RGBA:
    case WncImage::ARGB:
	 return true ;
    default:
	 return false ;
    }
  }

  // ---------------------------------------------------------------------------

  inline static char *getFreeMethodName(WncImage::FreeMethod m) {
    switch (m) {
    case WncImage::NONE: return "NONE" ;
    case WncImage::DELETE: return "DELETE" ;
    case WncImage::FREE: return "FREE" ;
    case WncImage::FREEMEM: return "FREEMEM" ;
    }
    return "?" ;
  }

  // ---------------------------------------------------------------------------

  WncImage::WncImage(WncImage& src) : _data(0), _fmethod(NONE) {
    _encoding = src._encoding ;
    setData(src._data, src._size, NONE) ;
    _width = src._width ;
    _height = src._height ;
  }

  WncImage&
  WncImage::operator = (WncImage& src) {
    if (&src!=this) {
	 _encoding = src._encoding ;
	 setData(src._data, src._size, NONE) ;
	 _width = src._width ;
	 _height = src._height ;
    }
    return *this ;
  }

  // ---------------------------------------------------------------------------

  void
  WncImage::prepareFor(unsigned int w, unsigned int h, Encoding e) {
    _width = w ; _height = h ;
    _encoding = e ;
    unsigned int size = (unsigned int)BytesPerImage(w,h,e) ;
    if (!size || _size==size) return ;
    unsigned char *ptr = AllocMem(size) ;
    setData(ptr, size, FREEMEM) ;
  }

  // ---------------------------------------------------------------------------

  void
  WncImage::setData(unsigned char *d, unsigned int s, FreeMethod m) {
    if (_data==d) {
	 if (!_data) {
	   _fmethod = NONE ;
	  _size = 0 ;
	 } else if (_fmethod!=NONE) {
	   // _data should be freed, but it was used in this call...
	   _size = s ;
	 } else {
	   _fmethod = m ;
	   _size = s ;
	 }
	 return ;
    }

    _size = s ;
    if (_fmethod) {
	 switch (_fmethod) {
	 case NONE:
	   break ;
	 case DELETE:
	   delete [] _data ;
	   _data = 0 ;
	   break ;
	 case FREE:
	   if (_data) free(_data) ;
	   _data = 0 ;
	   break ;
	 case FREEMEM:
	   WncImage::FreeMem(&_data) ;
	   break ;
	 }
    }

    _data = d ;
    _fmethod = m ;
  }

  // ---------------------------------------------------------------------------

  void
  WncImage::acquireData() {
    unsigned char *ptr = AllocMem(_size) ;
    memcpy(ptr, _data, _size) ;
    setData(ptr, _size, FREEMEM) ;
  }

  // ---------------------------------------------------------------------------

  void
  WncImage::stealDataFrom(WncImage &src) {
    if (&src==this) return ;
    _width = src._width ;
    _height = src._height ;
    _encoding = src._encoding ;
    setData(src._data, src._size, src._fmethod) ;
    src._fmethod = NONE ;
  }

  void
  WncImage::linkDataFrom(WncImage &src) {
    _width = src._width ;
    _height = src._height ;
    _encoding = src._encoding ;
    setData(src._data, src._size, WncImage::NONE) ;
  }

  void
  WncImage::copyDataFrom(const WncImage &src) {
    _encoding = src._encoding ;
    _width = src._width ;
    _height = src._height ;
    unsigned char *ptr = AllocMem(src._size) ;
    memcpy(ptr, src._data, src._size) ;
    setData(ptr, src._size, FREEMEM) ;
  }

  // ---------------------------------------------------------------------------

  unsigned char *
  WncImage::AllocMem(unsigned int size) {
    unsigned char *ptr = new unsigned char [size] ;

    return ptr ;
  }

  void
  WncImage::FreeMem(unsigned char **thePtr) {
    unsigned char *ptr = *thePtr ;
    if (!ptr) return ;

    delete [] ptr ;
    ptr = 0 ;
  }

  // ---------------------------------------------------------------------------

  unsigned int
  WncImage::getWidth(void) {
    return _width ;
  }

  unsigned int
  WncImage::getHeight(void) {
    return _height ;
  }

