/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */

#include "ugameStdAfx.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#endif

#include <osg/Matrix>
#include <osg/PositionAttitudeTransform>

#include <maf/application.h>
#include <maf/scene.h>
#include <ugame/artefact.h>
#include <ugame/ugameerror.h>

// Model

UGAMEArtefactModel::UGAMEArtefactModel() : mSelectable(false), mSelected(false)
{}
 
void UGAMEArtefactModel::Init(void) {
  SetNode(new osg::PositionAttitudeTransform);
}

void UGAMEArtefactModel::SetArtefact(osg::Node* node) {
  g_assert(GetPAT() != 0);
  GetPAT()->addChild(node);
}

osg::Node* UGAMEArtefactModel::GetArtefact(void) {
  g_assert(GetPAT() != 0);
  return GetPAT()->getChild(0);
}

// Controller

UGAMEArtefactController::~UGAMEArtefactController() {
  if(GetModel())
    Anchor(0);
}

void UGAMEArtefactController::Init(void) {
  if(!GetModel())
    SetModel(new UGAMEArtefactModel);
  MAFVisionController::Init();
}

void UGAMEArtefactController::SetSelected(bool selected) {
  GetModel()->SetSelected(selected);
}

void UGAMEArtefactController::SetSelectable(bool selectable) {
  if(selectable)
    BindToNode(GetModel()->GetNode());
  GetModel()->SetSelectable(selectable);
}

bool UGAMEArtefactController::Update(MAFApplication* application) {
  if(GetModel()->GetSelectable()) {
    SDL_Event* event = application->GetLastEvent(this);
    if(event) {
      if(application->GetFocus() == this) {
	if(event->type == SDL_MOUSEBUTTONDOWN && event->button.button == SDL_BUTTON_LEFT)
	  GetModel()->SetSelected(true);
      }
    }
  }
  return true;
}

void UGAMEArtefactController::Anchor(MAFAnchor* anchor) {
  if(GetModel() == 0)
    throw new UGAMEError(UNDERWARE_UGAME_ERROR_MODEL, "UGAMEArtefactController::Anchor: NULL model"); 
    
  MAFAnchor* previous_anchor = GetModel()->GetAnchor();

  if(previous_anchor == anchor) return;

  if(anchor)
    anchor->addChild(GetModel()->GetNode());
  
  if(previous_anchor != 0)
    previous_anchor->removeChild(GetModel()->GetNode());

  GetModel()->SetAnchor(anchor);
}

void UGAMEArtefactController::Displayed(bool displayed) {
  g_assert(GetModel() != 0 && GetModel()->GetNode() != 0);
  if(displayed)
    GetModel()->GetNode()->setNodeMask(0xffffffff);
  else
    GetModel()->GetNode()->setNodeMask(0x0);
}
