/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include "ugameStdAfx.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#endif

#ifndef WIN32
#	include <ugame/debug.h>
#endif // WIN32

#include <osg/Group>

osg::ref_ptr<UGAMEDebugController> UGAMEDebugSingleton::mController;

struct UGAMEDebugDummy : UGAMEDebugObject
{
  UGAMEDebugDummy() {}
  ~UGAMEDebugDummy() {}
  void Init(const osg::Vec3 &position, float width = 10.0f)
  {
    mShape = new osg::Box(position, width);
    UGAMEDebugObject::Init();
  }
};

struct UGAMEDebugVec3 : UGAMEDebugObject
{
  UGAMEDebugVec3() {}
  ~UGAMEDebugVec3() {}
  void Init(const osg::Vec3 &from, const osg::Vec3 &to)
  {
    const float radius = 2.f;
    osg::Vec3 direction = (to - from);
    float length = direction.length();
    direction.normalize();
    osg::Vec3 center = (from + to) / 2.0f;

    osg::Cylinder *cyl = new osg::Cylinder(center, radius, length);
    osg::Quat q;
    q.makeRotate(osg::Vec3(0.0f, 1.0f, 0.0f), direction); // humm it maybe fault
    cyl->setRotation(q);
    mShape = cyl;
    UGAMEDebugObject::Init();
  }
};

UGAMEDebugModel::UGAMEDebugModel(osg::Group* group)
{
  mGroup = new osg::Group;
  mGroup->setName("DebugNodes");
  group->addChild(mGroup.get());
}

UGAMEDebugModel::~UGAMEDebugModel()
{
}

void UGAMEDebugModel::Detach(void)
{
  mGroup->getParent(0)->removeChild(mGroup.get());
}

void UGAMEDebugModel::Init(void)
{
  UGAMEArtefactModel::Init();
}

void UGAMEDebugModel::AddObject(UGAMEDebugObject *object)
{
  mObjects.push_back(object);
  mGroup->addChild(object->mGeode.get());
}

void UGAMEDebugModel::AddObject(osg::Group *group, UGAMEDebugObject *object)
{
    mObjects.push_back(object);
    group->addChild(object->mGeode.get());
}

void UGAMEDebugModel::Clear(void)
{
  for(unsigned int i=0;i<mObjects.size();i++)
      mGroup->removeChild(mObjects[i]->mGeode.get());
  mObjects.clear();
}

UGAMEDebugController::UGAMEDebugController(osg::Group* group)
{
  SetModel(new UGAMEDebugModel(group));
  Init();
}

UGAMEDebugController::~UGAMEDebugController()
{
}

void UGAMEDebugController::AddDummy(const osg::Vec3 &position, float width)
{
  UGAMEDebugDummy *dummy = new UGAMEDebugDummy();
  dummy->Init(position, width);
  GetDebugModel()->AddObject(dummy);
}

void UGAMEDebugController::AddVec3(const osg::Vec3 &from, const osg::Vec3 &to)
{
  UGAMEDebugVec3 *vec3 = new UGAMEDebugVec3();
  vec3->Init(from, to);
  GetDebugModel()->AddObject(vec3);
}

void UGAMEDebugController::AddDummy(osg::Group *group, const osg::Vec3 &position, float width)
{
  UGAMEDebugDummy *dummy = new UGAMEDebugDummy();
  dummy->Init(position, width);
  GetDebugModel()->AddObject(group, dummy);
}

void UGAMEDebugController::AddVec3(osg::Group *group, const osg::Vec3 &from, const osg::Vec3 &to)
{
  UGAMEDebugVec3 *vec3 = new UGAMEDebugVec3();
  vec3->Init(from, to);
  GetDebugModel()->AddObject(group, vec3);
}

void UGAMEDebugController::Clear()
{
  GetDebugModel()->Clear();
}
