#
# Copyright (C) 2004 Mekensleep
#
# Mekensleep
# 24 rue vieille du temple
# 75004 Paris
#       licensing@mekensleep.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
# Authors:
#  Henry Precheur <henry@precheur.org>
#
#

# tiny example to test poker3d-interface

from twisted.internet.protocol import Protocol, Factory
from twisted.internet import reactor
from time import sleep

def makeTables(tables):
    variants = {}
    for table in tables:
        if not variants.has_key(table['variant']):
            variants[table['variant']] = []
        variants[table['variant']].append(table)
    packet = "lobby\0"
    packet += "table_list\0"
    packet += "Choose a poker table to join\0"
    packet += "%d\0" % len(variants) # number of tabs
    variant_names = variants.keys()
    variant_names.sort()
    for variant in variant_names:
        packet += "%d\0" % 12 # number of fields
        packet += "0\0001\0001\0001\0000\0000\0000\0000\0000\0000\0000\0000\0" # field types
        packet += "id\0name\0variant\0structure\0seats\0avg. pot\0hands/h\0%flop\0playing\0observing\0waiting\0timeout\0" # headers
        packet += "%d\0" % len(variants[variant])
        for table in variants[variant]:
            packet += "%d\0" % table['id']
            packet += "%s\0" % table['name']
            packet += "%s\0" % table['variant']
            packet += "%s\0" % table['betting_structure']
            packet += "%d\0" % table['seats']
            packet += "%d\0" % table['average_pot']
            packet += "%d\0" % table['hands_per_hour']
            packet += "%d\0" % table['percent_flop']
            packet += "%d\0" % table['players']
            packet += "%d\0" % table['observers']
            packet += "%d\0" % table['waiting']
            packet += "%d\0" % table['timeout']
        packet += "%s\0" % variant
    return packet

step = 1
class Echo(Protocol):
    def connectionMade(self):
        # self.in_position()
        # self.future_action()
        self.message()
        # self.chat()
        # self.top_menu()
        # self.table_list()
        #        self.showOutfits()
        #        self.buy_in()
        #        self.sit_actions()
        #        self.slider()
        # self.user_info()
        # self.yesno()
        # self.login()

    def message(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "message_box\000my message!\000")

    def yesno(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "yesno\000my message!\000")

    def login(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "login\000henry\000fuck\0001\000")

    def user_info(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "user_info\000henry\000henry@mekensleep.org\000tototo\000")
    
    def chat(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "chat\000show\000")
        delay += 1
        reactor.callLater(delay, self.transport.write, "chat\000line\000line 1\n\000")
        delay += 1
        reactor.callLater(delay, self.transport.write, "chat\000line\000line 2\n\000")
        delay += 1
        reactor.callLater(delay, self.transport.write, "chat\000line\000line 2\nline 2\nline 2\nline 2\nline 2\nline 2\nline 2\nline 2\n\000")
        reactor.callLater(delay, self.transport.write, "chat\000line\000line 2\nline 2\nline 2\nline 2\nline 2\nline 2\nline 2\nline 2\n\000")
        delay += 1
        reactor.callLater(delay, self.transport.write, "chat\000line\000line 3\n\000")
        delay += 20
        reactor.callLater(delay, self.transport.write, "chat\000hide\000")
        
        
    def slider(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "slider\00010\00020\00030\00010\000")

    def in_position(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "in_position\000show\000")
        delay += step * 5
        reactor.callLater(delay, self.transport.write, "in_position\000set\0000\0000\0005\00015\000BUTTON1\000BUTTON2\000BUTTON3\000")
        delay += step * 5
        reactor.callLater(delay, self.transport.write, "in_position\000set\00010\000100\0005\00015\000BUTTON1\000\000Raise %d\000")
        
    def buy_in(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "buy_in\000show\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "buy_in\000params\00020\000300.0\000Which amount?\000All your bankroll\000")
        reactor.callLater(delay, self.transport.write, "buy_in\000hide\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "buy_in\000show\000")

    def table_list(self):
        packet = makeTables([
            {'name': 'table 1',
             'variant': 'holdem',
             'betting_structure': 'limit 2/4',
             'id': 1,
             'seats': 5,
             'average_pot': 150,
             'hands_per_hour': 30,
             'percent_flop': 60,
             'players': 5,
             'observers': 5,
             'waiting': 5,
             'timeout': 5,
             },
            {'name': 'table 2',
             'variant': 'holdem',
             'betting_structure': 'limit 2/4',
             'id': 2,
             'seats': 5,
             'average_pot': 150,
             'hands_per_hour': 30,
             'percent_flop': 60,
             'players': 5,
             'observers': 5,
             'waiting': 5,
             'timeout': 5,
             }])
        print "packet %s" % packet
        reactor.callLater(0, self.transport.write, packet)

    def showOutfits(self):
        outfits = {1: 'outfit 1',
                   2: 'outfit 2',
                   3: 'outfit 3',
                   4: 'outfit 4'}
        packet = "lobby\0"
        packet += "outfit\0"
        packet += "Choose an outfit for your character\0"
        packet += "%d\0" % len(outfits)# number of tabs
        i = 0
        for type in outfits.keys():
            packet += "%d\0" % 2 # number of fields
            packet += "0\0001\0" # field types
            packet += "id\0name\0" # headers
            packet += "%d\0" % len(outfits[type])
            for outfit in outfits[type]:
                packet += "%d\0%s\0" % (i, outfit)
                i += 1
            packet += "%s\0" % type
        reactor.callLater(10, self.transport.write, packet)
        
    def top_menu(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "top_menu\000show\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "top_menu\000params\000Short title\000")
        delay += step

        
    def future_action(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "future_action\000show\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "future_action\000set\0001234\000\000Menu 1\000\000\000Menu 4\000\000\000\000Menu 8\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "future_action\000set\0001234\0007\000Menu 1\000\000\000Menu 4\000\000\000\000Menu 8\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "future_action\000set\0001234\0000\000Menu 1\000\000\000Menu 4\000\000\000\000Menu 8\000")
        delay += 30
        reactor.callLater(delay, self.transport.write, "future_action\000hide\000")

    def sit_actions(self):
        delay = 0
        reactor.callLater(delay, self.transport.write, "sit_actions\000show\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "sit_actions\000auto\000yes\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "sit_actions\000auto\000no\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "sit_actions\000sit_out\000yes\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "sit_actions\000sit_out\000no\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "sit_actions\000sit_out\000yes\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "sit_actions\000hide\000")
        delay += step
        reactor.callLater(delay, self.transport.write, "sit_actions\000show\000")
    
    def dataReceived(self, data):
        print "%s" % data

def main():
    f = Factory()
    f.protocol = Echo
    reactor.listenTCP(19379, f)
    reactor.run()

if __name__ == '__main__':
    main()
