import sys

global PATTERN_TYPES
PATTERN_TYPES = []

class StructuredText:
    def __init__(self, formatstr, formatargs):
        text = build_string(formatstr, formatargs)
        self.formatstr = text
        self.formatargs = formatargs
    def display(self, pattern_instance):
        dict = {}
        for arg in self.formatargs:
            dict[arg] = arg
        #print self.formatstr % dict
        return self.formatstr % dict

def build_string (targetstr, args):
    if len(args) == 0:
        return targetstr
    pos = targetstr.find('%')
    if pos == -1:
        sys.exit("Format argument mismatch")
    else:
        return targetstr[0:pos + 1] + "(" + args[0] + ')s' + build_string(targetstr[pos + 1:], args[1:])

class ProcessAbstraction:
    def __init__(self, name):
        self.name = name

class Process_Connection:
    def __init__(self, pattern, source_process, sink_process):
        self.source = source_process
        self.sink = sink_process
        self.parent = pattern

class Pattern:
    def __init__(self, name, process_participant_names, distinguished_role, require, prohibit, \
                 to_avoid = {}):
        global PATTERN_TYPES
        PATTERN_TYPES.append(name)
        self.name = name
        self.participants = []
        self.individual_constraints = []
        self.global_constraints = []
        self.gen_resource_types = "no"
        self.to_avoid = to_avoid
        self.template = None
        self.participants = process_participant_names
        self.distinguished_role = distinguished_role
        self.require = []

    def pat2macro (self):
        return self.name + "Instance"

    def __repr__(self):
        return "<Pattern " + self.name + ">"

def pattern_asserts_types (patstr):
    patobj = eval(patstr)
    return patobj.gen_resource_types

###### Patterns ####################

Pipeline = Pattern('Pipeline', ['begin', 'r1', 'middle', 'r2', 'end'], 'begin',  \
                   [['source', 'sink'], ['sink', 'next']], \
                   [['sink', 'source'], ['next', 'sink']],
                   {'r1': StructuredText('% is the only process allowed to write data to this resource', ['begin']),
                    'r2': StructuredText('% is the only process allowed to write data to this resource', ['middle']),
                    'begin': StructuredText('Data flowing to % must go through %', ['end', 'middle']),
                    'end': StructuredText('Data flowing from % must go through %', ['begin', 'middle'])})

Pipeline.gen_resource_types = "one_only"


HubAndSpoke = Pattern('HubAndSpoke', ['initiator', 'r2','generator', 'center', 'colleague'], \
                'center', [],[])

Proxy = Pattern('Proxy', ['proxy', 'r2','service','r3', 'client'], 'proxy', \
                [['client', 'proxy'], ['proxy', 'service']], \
                [['client', 'service']])

Proxy.gen_resource_types = "one_only"

Observer = Pattern('Observer', ['observer', 'service', 'client'], 'observer', \
                   [['client', 'service'], ['service', 'observer']], \
                   [['observer', 'service']])

Mediator = Pattern('Mediator', ['mediator', 'r2', 'r3', 'colleague'], 'mediator', \
                   [['colleague', 'mediator'], ['mediator', 'colleague']], \
                   [['colleague', 'colleague']])

SingleProcessMediator = Pattern('SingleProcessMediator', ['mediator', 'r1'], 'mediator', \
                   [['colleague', 'mediator'], ['mediator', 'colleague']], \
                   [['colleague', 'colleague']])

Logger = Pattern('Logger', ['application', 'log_file'], 'log_file', [], [], \
                 {'log_file' : StructuredText('% is the only process allowed to write to this file', \
                                              ['logger'])})
Logger.gen_resource_types = "one_only"

LibSelinuxInit = Pattern('LibSelinuxInit', ['application', 'mounts', 'new_access'], 'mounts', [], [], \
                         {'mounts' : StructuredText('Don"t audit unless there exists subsequent access to selinuxfs or a file in /etc/selinux', [])})

SharedLibrary = Pattern('SharedLibrary', ['application', 'lib_read'], 'lib_read', [], [])

TempUse = Pattern('TempUse', ['application', 'temp_file'], 'temp_file', [], [])

TempUse.gen_resource_types = "one_only"

Config = Pattern('Config', ['application', 'config_file'], 'config_file', [], [])

Config.gen_resource_types = "one_only"

CanCheckSelinux = Pattern('CanCheckSelinux', ['main', 'filesystems', 'current'], 'main', [], [])

ActiveObject = Pattern('ActiveObject', ['proxy', 'order', 'service', 'filled_order'], 'proxy', [], [])

CGI = Pattern('CGI', ['server', 'r1', 'shell', 'script'], 'script', [],[])

CGI.gen_resource_types = 'script'

ClientServer = Pattern('ClientServer', ['client', 'socket','server'],  'server', [], [])

Executable = Pattern('Executable', ['application', 'file','process'],  'application' , [], [])

Client = Pattern('Client', ['client', 'socket'], 'client', [], [])

Reactor = Pattern('Reactor', ['reactor', 'demultiplexer', 'event_handler', 'handle'], 'reactor', \
                  [['reactor', 'demultiplexer'], ['reactor', 'event_handler'],\
                    ['event_handler', 'reactor']], [])

Interpreter =  Pattern('Interpreter', ['application', 'code_file', 'interpreter'],\
                       'interpreter', [], [])

Pipe = Pattern('Pipe', ['parent', 'pipe', 'child'], 'pipe', [], [])

CanExec = Pattern('CanExec', ['parent', 'spawned'], 'parent', [], [])

Daemon = Pattern('Daemon', ['parent', 'child'], 'child', [], [])

Allow = Pattern('Allow', ['process_context', 'holder_context', 'holder_type', 'action'], 'process_context', [], [])
