from util import  *
import config
import os
from te_gen_util import PatternInstance,pat_instances, allowstr
"""For generating .te and .fc files from pattern instances.

gen methods produce the .te file data.

"""

class Declare(PatternInstance):
    def __init__(self, new_type, ty):
        self.ty = ty
        self.new_type = new_type
        pat_instances.append(self)
    def gen(self, commented_out = 0):
        return ['type ' + self.new_type + ', ' + self.ty + '; \n']

class ActiveObjectInstance (PatternInstance):
     def __init__(self,client,waitress,cook):
          self.client_participant = client
          self.waitress_participant = waitress
          self.cook_participant = cook
          pat_instances.append(self)
     def gen(self,commented_out = 0):
          return []

class CanExec(PatternInstance):
    def __init__(self, args):
        self.args = args # a set of context
        pat_instances.append(self)
    def gen(self, commented_out = 0):
        if len(self.args) > 1:
            ans = [write_macro(commented_out, 'can_exec', self.args)]
        return ans

class AllowInstance (PatternInstance):
     def __init__(self,process_context,holder_context,holder_type,action):
          """ contains logic for setting actions allowed"""
          self.process_context_participant = process_context
          self.holder_context_participant = holder_context
          self.holder_type_participant = holder_type
          self.action_participant = action
          if action == 'read' and holder_type == 'File':
              self.action_participant = '{read getattr}'
          elif action == 'open':
              self.action_participant = '{getattr search}'
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          ans = []
          prefix = ""
          if commented_out:
              prefix = "#"
          if self.action_participant == 'exec':
              ans.append(write_macro(commented_out, 'can_exec',\
                         [self.process_context_participant, self.holder_context_participant]))
          else:
              ans.append(write_allow(commented_out,allowstr(self.process_context_participant, \
                     self.holder_context_participant, \
                     self.holder_type_participant, \
                     self.action_participant)))

          return ans

class CanCheckSelinuxInstance (PatternInstance):
     def __init__(self,main,filesystems,current):
          self.main_participant = main
          self.filesystems_participant = filesystems
          self.current_participant = current
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          ans = []
          ans.append(write_allow(commented_out,allowstr(self.main_participant, \
                       self.filesystems_participant, \
                       'File', \
                       'read')))
          ans.append(write_allow(commented_out,allowstr(self.main_participant, \
                       self.current_participant, \
                       'File', \
                       'read')))
          return ans

class InterpreterInstance (PatternInstance):
     def __init__(self, application, code_file, interpreter):
          self.application_participant = application
          self.code_file_participant = code_file
          self.interpreter_participant = interpreter
          pat_instances.append(self)
     def gen(self, commented_out = 0):
       ans = []
       ans.append(write_allow(commented_out,allowstr(self.application_participant, \
                    self.code_file_participant,  \
                    'File', \
                    'read')))
       ans.append(write_allow(commented_out,allowstr(self.application_participant, \
                    self.interpreter_participant,  \
                    'File', \
                    'read')))
       return ans

class PipeInstance (PatternInstance):
     def __init__(self, parent, pipe, child):
          self.parent_participant = parent
          self.pipe_participant = pipe
          self.child_participant = child
          pat_instances.append(self)
     def gen(self, commented_out = 0):
       prefix = ""
       if commented_out:
           prefix = "#"
       ans = []
       ans.append(write_allow(commented_out,allowstr(self.parent_participant, \
                    self.pipe_participant, \
                    'fifo_file', \
                    '{read write getattr}')))
       ans.append(write_macro(commented_out, 'can_exec', [self.parent_participant, self.parent_participant]))
       return ans

class ConfigInstance (PatternInstance):
     def __init__(self,application,config_file):
          self.application_participant = application
          self.config_file_participant = config_file
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          ans = [write_allow(commented_out,allowstr(self.application_participant, \
                      self.config_file_participant, \
                      'File', \
                      'read'))]
          return ans

class LibSelinuxInitInstance (PatternInstance):
     def __init__(self,application,mounts,new_access):
          self.application_participant = application
          self.mounts_participant = mounts
          self.new_access_participant = new_access
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          ans = [write_allow(commented_out,allowstr(self.application_participant, \
                      self.mounts_participant, \
                      'File', \
                      'read')), \
          write_allow(commented_out,allowstr(self.application_participant, \
                      self.new_access_participant, \
                      'File', \
                      'read'))]
          return ans

class LoggerInstance (PatternInstance):
     def __init__(self,application,log_file):
          self.application_participant = application

          self.log_file_participant = log_file
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          ans = [write_allow(commented_out,allowstr(self.application_participant, \
                      self.log_file_participant, \
                      'File', \
                      'write'))]
          return ans

class MediatorInstance (PatternInstance):
     def __init__(self,mediator,r2,r3,colleague):
          self.mediator_participant = mediator
          self.r2_participant = r2
          self.r3_participant = r3
          self.colleague_participant = colleague
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          return []

class ObserverInstance (PatternInstance):
     def __init__(self,observer,service,client):
          self.observer_participant = observer
          self.service_participant = service
          self.client_participant = client
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          return []

class PipelineInstance (PatternInstance):
     def __init__(self,begin,r1,middle,r2,end):
          self.begin_participant = begin
          self.r1_participant = r1

          self.middle_participant = middle
          self.r2_participant = r2
          self.end_participant = end
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          ans = [write_allow(commented_out,allowstr(self.begin_participant, \
                       self.r1_participant, \
                       'File', \
                       'write')), \
          write_allow(commented_out,allowstr(self.middle_participant, \
                       self.r1_participant, \
                       'File', \
                       'read')), \
          write_allow(commented_out,allowstr(self.middle_participant, \
                       self.r2_participant, \
                       'File', \
                       'write')), \
          write_allow(commented_out,allowstr(self.end_participant, \
                       self.r2_participant, \
                       'File', \
                       'read'))]
          return ans

class ProxyInstance (PatternInstance):
     def __init__(self,proxy,r2,service,r3,client):
          self.proxy_participant = proxy
          self.r2_participant = r2
          self.service_participant = service
          self.r3_participant = r3
          self.client_participant = client
          pat_instances.append(self)
     def gen(self, commented_out = 0):
         return []

class ReactorInstance (PatternInstance):

     def __init__(self,reactor,demultiplexer,event_handler,handle):
          self.reactor_participant = reactor
          self.demultiplexer_participant = demultiplexer
          self.event_handler_participant = event_handler
          self.handle_participant = handle
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          return []

class SharedLibraryInstance (PatternInstance):
     def __init__(self,application,lib_read):
          self.application_participant = application
          self.lib_read_participant = lib_read
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          ans = [write_allow(commented_out,allowstr(self.application_participant, \
                      self.lib_read_participant, \
                      'File', \
                      'read'))]
          return ans

class TempUseInstance (PatternInstance):
     def __init__(self,application,temp_file):
          self.application_participant = application
          self.temp_file_participant = temp_file
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          ans = [write_allow(commented_out,allowstr(self.application_participant, \
                      self.temp_file_participant, \
                      'File', \
                      'read'))]
          return ans

class WebServerInstance (PatternInstance):
     def __init__(self,server,r1,shell,r2,r3,script):
          self.server_participant = server
          self.r1_participant = r1
          self.shell_participant = shell
          self.r2_participant = r2
          self.r3_participant = r3
          self.script_participant = script
          pat_instances.append(self)
     def gen(self, commented_out = 0):
          return []

def gen_te():
    prgm = get_current_program()
    if prgm == None:
        pname = 'current'
    else:
        pname = prgm.name
    fileid  = pname + ".te"
    fileStr = os.getcwd() + '/' + fileid
    strm = open(fileStr, "w")
    print "Writing to " + fileStr
    strm.write('#DESC - ' + pname + '\n# \n')
    strm.write('# This file was automatically generated from ' + pname + \
               '_policy_spec.py.  \n# Evidence for the data herein can be found as comments in that file. \n')
    strm.write('##################################### \n\n')
    all = []
    for x in pat_instances:
        all = all + x.gen()
    use = seq2set(all)
    types = [x for x in use if x.find('type') == 0]
    allows = setdiff(use, types)
    strm.write('daemon_domain(' + pname + ')\n\n')
    strm.write('# Types for ' + pname + '\n#\n')
    for item in types:
        strm.write(item + ' \n' )
    strm.write('# Allow statements \n#\n')
    for aitem in allows:
        strm.write(aitem + ' \n' )

def write_allow(commented_out, txt):
    prefix = ""
    if commented_out:
        prefix = "#"
    return prefix + txt

def write_macro(commented_out, mname, args):
    prefix = ""
    if commented_out:
        prefix = "#"
    toreturn = prefix + context2type(mname) + '(' + args[0] + ',{'
    for a in args[1:]:
        toreturn = toreturn + context2type(a) + " "
    return toreturn + '});'
