Summary: SELinux policy core utilities.
Name: policycoreutils
Version: 1.12
Release: 1
License: GPL
Group: System Environment/Base
Source: http://www.nsa.gov/selinux/archives/policycoreutils-1.12.tgz
Prefix: %{_prefix}
BuildRequires: libselinux-devel

BuildRoot: %{_tmppath}/%{name}-buildroot

%description
Security-enhanced Linux is a patch of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

policycoreutils contains the policy core utilities that are required
for basic operation of a SELinux system.  These utilities include
load_policy to load policies, setfiles to label filesystems, newrole
to switch roles, and run_init to run /etc/init.d scripts in the proper
context.

%prep
%setup -q

%build
make all 

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man1
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}/pam.d
make DESTDIR="${RPM_BUILD_ROOT}" install

%find_lang %{name}

%clean
rm -rf ${RPM_BUILD_ROOT}

%files -f %{name}.lang
%defattr(-,root,root)
%{_sbindir}/setfiles
/sbin/fixfiles
%{_mandir}/man8/fixfiles.8.gz
/sbin/restorecon
%{_mandir}/man8/restorecon.8.gz
%{_sbindir}/sestatus
%{_mandir}/man8/sestatus.8.gz
%config(noreplace) %{_sysconfdir}/sestatus.conf
%{_sbindir}/genhomedircon
%{_mandir}/man8/setfiles.8.gz
%{_sbindir}/load_policy
%{_bindir}/newrole
%{_bindir}/audit2allow
%{_mandir}/man1/newrole.1.gz
%config %{_sysconfdir}/pam.d/newrole
%{_sbindir}/run_init
%config %{_sysconfdir}/pam.d/run_init
%{_mandir}/man8/run_init.8.gz

%changelog
* Wed Jan 28 2004 Dan Walsh <dwalsh@redhat.com> 1.4-6
- fix genhomedircon not to return and error 

* Wed Jan 28 2004 Dan Walsh <dwalsh@redhat.com> 1.4-5
- add setfiles quiet patch

* Tue Jan 27 2004 Dan Walsh <dwalsh@redhat.com> 1.4-4
- add checkcon to verify context match file_context

* Wed Jan 7 2004 Dan Walsh <dwalsh@redhat.com> 1.4-3
- fix command parsing restorecon

* Tue Jan 6 2004 Dan Walsh <dwalsh@redhat.com> 1.4-2
- Add restorecon

* Sat Dec 6 2003 Dan Walsh <dwalsh@redhat.com> 1.4-1
- Update to latest NSA 1.4

* Tue Nov 25 2003 Dan Walsh <dwalsh@redhat.com> 1.2-9
- Change run_init.console to run as run_init_t

* Tue Oct 14 2003 Dan Walsh <dwalsh@redhat.com> 1.2-8
- Remove dietcc since load_policy is not in mkinitrd
- Change to use CONSOLEHELPER flag

* Tue Oct 14 2003 Dan Walsh <dwalsh@redhat.com> 1.2-7
- Don't authenticate run_init when used with consolehelper

* Wed Oct 01 2003 Dan Walsh <dwalsh@redhat.com> 1.2-6
- Add run_init consolehelper link

* Wed Sep 24 2003 Dan Walsh <dwalsh@redhat.com> 1.2-5
- Add russell spead up patch to deal with file path stems

* Fri Sep 12 2003 Dan Walsh <dwalsh@redhat.com> 1.2-4
- Build load_policy with diet gcc in order to save space on initrd

* Fri Sep 12 2003 Dan Walsh <dwalsh@redhat.com> 1.2-3
- Update with NSA latest

* Thu Aug 7 2003 Dan Walsh <dwalsh@redhat.com> 1.2-1
- remove i18n
- Temp remove gtk support

* Thu Aug 7 2003 Dan Walsh <dwalsh@redhat.com> 1.1-4
- Remove wnck requirement

* Thu Aug 7 2003 Dan Walsh <dwalsh@redhat.com> 1.1-3
- Add gtk support to run_init

* Tue Aug 5 2003 Dan Walsh <dwalsh@redhat.com> 1.1-2
- Add internationalization

* Mon Jun 2 2003 Dan Walsh <dwalsh@redhat.com> 1.0-1
- Initial version

