
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#ifndef POLYGRAPH__LOGANALYZERS_LEVELTRACEFIG_H
#define POLYGRAPH__LOGANALYZERS_LEVELTRACEFIG_H

#include "xstd/String.h"
#include "loganalyzers/ReportTraceFigure.h"

class LevelStex;
class PhaseInfo;
class PhaseTrace;
class StatIntvlRec;

// creates level trace figure based on interval level stats
class LevelTraceFig: public ReportTraceFigure {
	public:
		typedef LevelStex Stex;

	public:
		LevelTraceFig();

		void stats(const Stex *aStex1, const Stex *aStex2, const PhaseInfo *phase);

	protected:
		virtual int createCtrlFile();
		virtual void setCtrlOptions();

		int dumpDataLines(const LevelStex *stex);
		int dumpDataLine(const LevelStex *stex, Time stamp, const StatIntvlRec &r);
		
	protected:
		const Stex *theStex1;
		const Stex *theStex2;
		const PhaseInfo *thePhase;
		const PhaseTrace *theTrace;
};

#endif
