
/* Web Polygraph       http://www.web-polygraph.org/
 * (C) 2003-2006 The Measurement Factory
 * Licensed under the Apache License, Version 2.0 */

#ifndef POLYGRAPH__PGL_SSLWRAPSYM_H
#define POLYGRAPH__PGL_SSLWRAPSYM_H

#include "xstd/Array.h"
#include "xstd/Size.h"
#include "pgl/PglRecSym.h"

class StrIdentifier;

// a set of addresses that talk SSL and parameters for SSL protocol
class SslWrapSym: public RecSym {
	public:
		static String TheType;

	public:
		SslWrapSym();
		SslWrapSym(const String &aType, PglRec *aRec);

		virtual bool isA(const String &type) const;

		String rootCertificate() const;
		String sharingGroup() const;
		RndDistr *protocols(const StrIdentifier &protocolNames) const;
		bool rsaKeySizes(Array<Size>&, RndDistr *&) const;
		bool ciphers(Array<String*> &, RndDistr *&) const;
		bool sessionResumpt(double &prob) const;
		bool sessionCacheSize(int &count) const;
		String sslConfigFile() const;

	protected:
		virtual SynSym *dupe(const String &dType) const;
};

#endif
