#ifndef foomcalignhfoo
#define foomcalignhfoo

/* $Id: mcalign.h 286 2004-11-17 00:05:25Z lennart $ */

/***
  This file is part of polypaudio.
 
  polypaudio is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) any later version.
 
  polypaudio is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.
 
  You should have received a copy of the GNU Lesser General Public
  License along with polypaudio; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA.
***/

#include "memblock.h"
#include "memchunk.h"

/* An alignment object, used for aligning memchunks to multiples of
 * the frame size. */

/* Method of operation: the user creates a new mcalign object by
 * calling pa_mcalign_new() with the appropriate aligning
 * granularity. After that he may call pa_mcalign_push() for an input
 * memchunk. After exactly one memchunk the user has to call
 * pa_mcalign_pop() until it returns -1. If pa_mcalign_pop() returns
 * 0, the memchunk *c is valid and aligned to the granularity. Some
 * pseudocode illustrating this:
 *
 * struct pa_mcalign *a = pa_mcalign_new(4, NULL);
 *
 * for (;;) {
 *   struct pa_memchunk input;
 *
 *   ... fill input ... 
 *
 *   pa_mcalign_push(m, &input);
 *   pa_memblock_unref(input.memblock);
 * 
 *   for (;;) {
 *     struct pa_memchunk output;
 *
 *     if (pa_mcalign_pop(m, &output) < 0)
 *       break;
 *
 *     ... consume output ...
 *
 *     pa_memblock_unref(output.memblock);
 *   }
 * }
 *
 * pa_memchunk_free(a);
 * */

struct pa_mcalign;

struct pa_mcalign *pa_mcalign_new(size_t base, struct pa_memblock_stat *s);
void pa_mcalign_free(struct pa_mcalign *m);

/* Push a new memchunk into the aligner. The caller of this routine
 * has to free the memchunk by himself. */
void pa_mcalign_push(struct pa_mcalign *m, const struct pa_memchunk *c);

/* Pop a new memchunk from the aligner. Returns 0 when sucessful,
 * nonzero otherwise. */
int pa_mcalign_pop(struct pa_mcalign *m, struct pa_memchunk *c);

#endif
