/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxcalc-globals.h"

#include "polyxcalc-ui-calculator.h"
#include "polyxcalc-ui-chempad.h"
#include "polyxcalc-ui-recorder.h"


GtkWidget *
polyxcalc_ui_recorder_wnd_setup_window (PxmCalcCtxt *calcctxt)
{
  GtkWidget *widget = NULL;

  GtkTextIter text_iter;
  GtkTextBuffer *buffer = NULL;

  GladeXML *xml = NULL;
  
  gchar *gui_file = NULL;
  

  g_assert (calcctxt != NULL);
  

  gui_file = 
    g_strdup_printf ("%s/polyxcalc.glade", userspec->gladedir);
      
  g_assert (gui_file != NULL);
      
  xml = glade_xml_new (gui_file, "polyxcalc_recorder_wnd", 
		       PACKAGE);
  g_free (gui_file);
  
  if (xml == NULL)
    {
      g_critical (_("%s@%d: failed to load the interface\n"),
	     __FILE__, __LINE__);

      return NULL;
    }
      
  calcctxt->recorder_wnd = 
    glade_xml_get_widget (xml, 
			  "polyxcalc_recorder_wnd");
      
  if (calcctxt->recorder_wnd == NULL)
    {
      g_critical (_("%s@%d: failed to create the recorder window\n"),
	     __FILE__, __LINE__);

      return NULL;
    }

  widget = glade_xml_get_widget (xml, "recorder_textview");
  g_assert (widget != NULL);
  g_object_set_data (G_OBJECT (calcctxt->recorder_wnd),
		     "recorder_textview", widget);
      
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget));
      
  /* Get start of buffer; each insertion will revalidate the
   * iterator to point to just after the inserted text.
   */
  gtk_text_buffer_get_iter_at_offset (buffer, &text_iter, 0);
      
  gtk_text_buffer_insert (buffer, &text_iter, 
			  _("Recorder: each new operation is"
			    " recorded in this text view\n\n"), -1);
      
  g_signal_connect (G_OBJECT (calcctxt->recorder_wnd),
		    "delete_event",
		    G_CALLBACK 
		    (polyxcalc_ui_recorder_wnd_delete_event),
		    calcctxt);
      
  g_signal_connect (G_OBJECT (calcctxt->recorder_wnd),
		    "destroy_event",
		    G_CALLBACK 
		    (polyxcalc_ui_recorder_wnd_destroy_event),
		    calcctxt);
      
  /* We don't need the GladeXML object any more, so unref it
   * to save some memory 
   */
  g_object_unref (G_OBJECT (xml));
      
  gtk_widget_show_all (GTK_WIDGET (calcctxt->recorder_wnd));
    
  return calcctxt->recorder_wnd;
}


void
polyxcalc_ui_recorder_wnd_append_record (PxmCalcCtxt *calcctxt, 
					 gchar *record)
{
  GtkWidget *textview = NULL;

  GtkTextIter text_iter;
  GtkTextBuffer *buffer = NULL;
  

  g_assert (calcctxt != NULL);

  g_assert (calcctxt->recorder_wnd != NULL);
  
  g_assert (record != NULL);
  if (strlen (record) <= 0)
    return;
  
  textview = g_object_get_data (G_OBJECT (calcctxt->recorder_wnd),
				"recorder_textview");
  g_assert (textview != NULL);
  
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (textview));
  
  /* Get end of buffer; each insertion will revalidate the
   * iterator to point to just after the inserted text.
   */
  gtk_text_buffer_get_end_iter (buffer, &text_iter);
  
  gtk_text_buffer_insert (buffer, &text_iter, record, -1);
  
  return;
}



/* WINDOW LIFE CYCLE-RELATED FUNCTIONS
 */
gboolean
polyxcalc_ui_recorder_wnd_delete_event (GtkWidget *widget,
				     GdkEvent *event,
				     gpointer data)
{
  PxmCalcCtxt *calcctxt = data;


  g_assert (calcctxt != NULL);
  g_assert (calcctxt->recorder_wnd != NULL);

  gtk_widget_hide (GTK_WIDGET (calcctxt->recorder_wnd));

  return TRUE;
}


gboolean
polyxcalc_ui_recorder_wnd_destroy_event (GtkWidget *widget,
					 GdkEvent *event,
					 gpointer data)
{
  return FALSE;
}


