/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "polyxedit-editctxt.h"



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmEditCtxt *
polyxedit_editctxt_new (void)
{
  PxmEditCtxt *editctxt = g_malloc0 (sizeof (PxmEditCtxt));
  
  
  editctxt->propGPA = g_ptr_array_new ();
  
  return editctxt;
}



/*  LOCATING FUNCTIONS
 */
gint
polyxedit_editctxt_get_index_by_polymer (PxmPolymer *polymer,
					   GPtrArray *GPA)
{
  gint iter = 0;
  
  PxmEditCtxt *editctxt = NULL;
  
  g_assert (polymer != NULL);
  g_assert (GPA != NULL);
  
  for (iter = 0; iter < GPA->len; iter++)
    {
      editctxt = g_ptr_array_index (GPA, iter);
      
      if (editctxt->polymer == polymer)
	return iter;
    }
  
  return -1;
}


PxmEditCtxt *
polyxedit_editctxt_get_ptr_by_polymer (PxmPolymer *polymer,
					 GPtrArray *GPA)
{
  gint iter = 0;
  
  PxmEditCtxt *editctxt = NULL;
  
  g_assert (polymer != NULL);
  g_assert (GPA != NULL);
  
  for (iter = 0; iter < GPA->len; iter++)
    {
      editctxt = g_ptr_array_index (GPA, iter);
      
      if (editctxt->polymer == polymer)
	return editctxt;
    }
  
  return NULL;
}


gint
polyxedit_editctxt_get_index (PxmEditCtxt *editctxt,
				GPtrArray *GPA)
{
  gint iter = 0;
  
  PxmEditCtxt *editctxt_iter = NULL;
  
  g_assert (editctxt != NULL);
  g_assert (GPA != NULL);
  
  for (iter = 0; iter < GPA->len; iter++)
    {
      editctxt_iter = g_ptr_array_index (GPA, iter);
      
      if (editctxt_iter == editctxt)
	return iter;
    }
  
  return -1;
}



/* REFERENCE COUNTING MANAGEMENT
 */
gint
polyxedit_editctxt_remove_from_GPA (PxmEditCtxt *editctxt, 
				      GPtrArray *GPA)
{
  g_assert (editctxt != NULL);
  g_assert (GPA != NULL);
  

  if (FALSE == g_ptr_array_remove (GPA, editctxt))
    {
      g_warning (_("%s@%d: failed to remove polymer sequence context "
		   "in which polymer has name: '%s'\n"),
		 __FILE__, __LINE__, editctxt->polymer->plminfo->name);
      
      return -1;
    }

  return GPA->len;
}





/* FREE'ING FUNCTIONS
 */
gboolean
polyxedit_editctxt_free (PxmEditCtxt *editctxt)
{

  g_assert (editctxt != NULL);
  

  /* Start with internal data:
   */
  libpolyxmass_prop_GPA_free (editctxt->propGPA);

  /*
    debug_printf (("freed editctxt's prop array\n"));
  */

  if (editctxt->calcopt != NULL)
    pxmchem_calcopt_free (editctxt->calcopt);
  
  if (editctxt->ionizerule != NULL)
    pxmchem_ionizerule_free (editctxt->ionizerule);
  
  if (editctxt->polymer != NULL)
    pxmchem_polymer_free (editctxt->polymer);

  /* The function below will only free the polymer chemistry
     definition context (and associated polchemdef) if and only if
     there is not any such polymer chemistry definition context in
     use.

     Note that it might happen that the polchemdefctxt pointer is
     NULL, which happens when creation of a polymer chemistry
     definition context fails and as a result an editctxt is freed
     also prior to setting its variable to a new allocated
     polchemdefctxt (see function
     polyxedit_main_prepare_new_context_open_file () for an example of
     such a situation).
   */
  if (editctxt->polchemdefctxt != NULL)
    {
      if (-1 == polyxmass_polchemdefctxt_unref (editctxt->polchemdefctxt))
	{
	  g_critical ("%s@%d: failed to unref polymer chemistry definition"
		   "context from main global array: '%s'\n",
		 __FILE__, __LINE__, 
		 editctxt->polchemdefctxt->polchemdef->type);
	  
	  return FALSE;
	}
    }
  
  /* Same possibility is valid for seqeditorctxt:
   */
  if (editctxt->seqeditorctxt != NULL)
    polyxedit_seqeditorctxt_free (editctxt->seqeditorctxt);

  g_free (editctxt);

  return TRUE;
}


/* GPtrArray-RELATED FUNCTIONS
 */
gint
polyxedit_editctxt_GPA_free (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmEditCtxt *editctxt = NULL;
  

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      editctxt = g_ptr_array_remove_index (GPA, 0);
      g_assert (editctxt != NULL);
      polyxedit_editctxt_free (editctxt);
      count++;
    }
  
  g_ptr_array_free (GPA, TRUE);

  return count;
}

